
package fred;

import java.awt.Color;
import javax.swing.JFrame;

import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;

public class DemoXYPlot2 extends JFrame {
	private static final long serialVersionUID =
		-7758426045859369865L;
	public DemoXYPlot2() {
        XYPlot xyplot = new XYPlot();
        // Dfinir les axes du systme de coordonnes
        // Les abscisses
        NumberAxis na = new NumberAxis("Annes");
        na.setRange(2000.0, 2010.0);
        //na.setStandardTickUnits(
        //        NumberAxis.createIntegerTickUnits());
        // Ou bien
        na.setTickUnit(new NumberTickUnit(1.0));
        xyplot.setDomainAxis(na);
        // Les ordonnes
        na = new NumberAxis("Bnfices");
        na.setAutoRange(true);
        xyplot.setRangeAxis(na);
        
        // Crer une collection de donnes
        XYSeries xys = XYSeriesCreator.createXYSeries("XY Series 1");
        XYSeriesCollection data = new XYSeriesCollection();
        data.addSeries(xys);
        xys = XYSeriesCreator.createXYSeries("XY Series 2");
        data.addSeries(xys);
        // Crer l'objet de rendu des donnes
        XYItemRenderer xyir = new StandardXYItemRenderer();
        xyir.setSeriesPaint(0, Color.MAGENTA);
        // Et affecter tout a au Plot
        //xyplot.setDataset(data);
        // ou bien
         xyplot.setDataset(0, data);
        //xyplot.setRenderer(xyir);
        // ou bien
        xyplot.setRenderer(0, xyir);
        
        // Crer une deuxime collections de donnes
        // et la rendre sous forme de surfaces
        xys = XYSeriesCreator.createXYSeries("XY Surface Series 1");
        data = new XYSeriesCollection();
        data.addSeries(xys);
        xyir = new XYAreaRenderer();
        xyir.setSeriesPaint(0, Color.LIGHT_GRAY);
        xyplot.setDataset(1, data);
        xyplot.setRenderer(1, xyir);
        
        //xyplot.setDatasetRenderingOrder(
        //        DatasetRenderingOrder.FORWARD);
        // ou bien
        xyplot.setDatasetRenderingOrder(
                DatasetRenderingOrder.REVERSE);
        
        JFreeChart chart =new JFreeChart(
                    "Graphique personnalis", xyplot);
        ChartPanel chartPanel = new ChartPanel(chart);
        setContentPane(chartPanel);
    }
    public static void main(String[] args) {
        DemoXYPlot2 demo = new DemoXYPlot2();
        demo.setDefaultCloseOperation(EXIT_ON_CLOSE);
        demo.setSize(500, 300);
        demo.setVisible(true);
    }
}