(import '(java.util.concurrent Executors TimeUnit))

(let [tableau (ref []) ; Une rfrence sur un tableau vide
      valeur (ref 0)   ; Une rfrence sur une valeur initialise  0
      nb_threads 2     ; 2 threads 
      n 100            ; 100 itrations
      pool (Executors/newFixedThreadPool nb_threads)]

  (dotimes [th nb_threads]
    (.submit pool (fn []
                    (dotimes [i n]
                      (let [nouvelle-valeur (dosync (alter valeur inc))]
                        (dosync (commute tableau conj nouvelle-valeur)))))
                   nil))
  (.shutdown pool)
  (.awaitTermination pool 1 TimeUnit/MINUTES)
 
  (println "Nombre de valeurs :" (count @tableau))
  (println "Contenu du tableau:")
  (println @tableau))