using System;
using System.Collections.Generic;
using System.ComponentModel;
using Microsoft.Ccr.Core;
using Microsoft.Dss.Core.Attributes;
using Microsoft.Dss.ServiceModel.Dssp;
using Microsoft.Dss.ServiceModel.DsspServiceBase;
using W3C.Soap;

namespace ServiceAbonnement
{
    /// <summary>
    /// ServiceAbonnement contract class
    /// </summary>
    public sealed class Contract
    {
        /// <summary>
        /// DSS contract identifer for ServiceAbonnement
        /// </summary>
        [DataMember]
        public const string Identifier = "http://schemas.tempuri.org/2009/02/serviceabonnement.html";
    }

    /// <summary>
    /// ServiceAbonnement state
    /// </summary>
    [DataContract]
    public class ServiceAbonnementState
    {
        string _conseil = "Abonnez vous! :) ";

        [DataMember]
        [DisplayName("Un bon conseil")]
        public string Conseil
        {
            get { return _conseil; }
            set { _conseil = value; }
        }
    }

    /// <summary>
    /// ServiceAbonnement main operations port
    /// </summary>
    [ServicePort]
    public class ServiceAbonnementOperations : PortSet<DsspDefaultLookup, DsspDefaultDrop, Get, Subscribe>
    {
    }

    /// <summary>
    /// ServiceAbonnement get operation
    /// </summary>
    public class Get : Get<GetRequestType, PortSet<ServiceAbonnementState, Fault>>
    {
        /// <summary>
        /// Creates a new instance of Get
        /// </summary>
        public Get()
        {
        }

        /// <summary>
        /// Creates a new instance of Get
        /// </summary>
        /// <param name="body">the request message body</param>
        public Get(GetRequestType body)
            : base(body)
        {
        }

        /// <summary>
        /// Creates a new instance of Get
        /// </summary>
        /// <param name="body">the request message body</param>
        /// <param name="responsePort">the response port for the request</param>
        public Get(GetRequestType body, PortSet<ServiceAbonnementState, Fault> responsePort)
            : base(body, responsePort)
        {
        }
    }

    /// <summary>
    /// ServiceAbonnement subscribe operation
    /// </summary>
    public class Subscribe : Subscribe<SubscribeRequestType, PortSet<SubscribeResponseType, Fault>>
    {
        /// <summary>
        /// Creates a new instance of Subscribe
        /// </summary>
        public Subscribe()
        {
        }

        /// <summary>
        /// Creates a new instance of Subscribe
        /// </summary>
        /// <param name="body">the request message body</param>
        public Subscribe(SubscribeRequestType body)
            : base(body)
        {
        }

        /// <summary>
        /// Creates a new instance of Subscribe
        /// </summary>
        /// <param name="body">the request message body</param>
        /// <param name="responsePort">the response port for the request</param>
        public Subscribe(SubscribeRequestType body, PortSet<SubscribeResponseType, Fault> responsePort)
            : base(body, responsePort)
        {
        }
    }
}


