
package patterndecorateur;

interface Arme {
    public String tirer(UniteCombat iuc);
}


class Fusil implements Arme {
    public String tirer(UniteCombat detenteur) {
	if(detenteur instanceof Humain)
	    return "tir fusil";
	else
	    return "";
    }
}

interface IUniteCombat {
    public String deplacer();
    public String tirer();
    public void setArme(Arme arme);
    public String getFiche();
}

abstract class UniteCombat implements IUniteCombat {
    protected int pv; // points de vie
    protected Arme arme;
}

abstract class Humain extends UniteCombat {
}

class Soldat extends Humain {
    public String deplacer() {
	return "Deplacement";
    }
    
    public String tirer() {
	return (arme == null) ? "" : arme.tirer(this);
    }
    
    public void setArme(Arme arme) {
	this.arme = arme;
    }
    
    public String getFiche() {
	return "Soldat";
    }
}

// Cette classe drive de UniteCombat seulement
// pour la compatibilit de type
class UniteElite extends UniteCombat {
    UniteCombat uc;
    
    UniteElite(UniteCombat uc) {
	this.uc = uc;
    }
    
    public String deplacer() {
	return uc.deplacer() +" rapide et furtif";
    }
    
    public String tirer() {
	String tir  = "Action efficace: ";
	tir += uc.tirer();
	return tir;
    }
    
    public void setArme(Arme arme) {
	uc.setArme(arme);
    }
    
    public String getFiche() {
	return uc.getFiche() + " elite";
    }
}

class UniteEspion extends UniteCombat {
    UniteCombat uc;
    
    UniteEspion(UniteCombat uc) {
	this.uc = uc;
    }
    
    public String deplacer() {
	return uc.deplacer() + " acquisition de renseignements";
    }
    
    public String tirer() {
	return uc.tirer();
    }
    
    public void setArme(Arme arme) {
	uc.setArme(arme);
    }
    
    public String getFiche() {
	return uc.getFiche() + " espion";
    }
}

public class DemoDecorateur {
    public static void main(String[] args) {
	System.out.println("Debut partie");
	UniteCombat[] armee = new UniteCombat[2];
	armee[0] = new Soldat();
	armee[0].setArme(new Fusil());
	armee[1] = new Soldat();
	armee[1].setArme(new Fusil());
	System.out.println(armee[0].tirer());
	System.out.println(armee[1].tirer());
	System.out.println(armee[0].deplacer());
	System.out.println(armee[1].deplacer());
	System.out.println(armee[0].getFiche());
	System.out.println(armee[1].getFiche());
	
	System.out.println("Promotion d'un soldat");
	armee[1] = new UniteElite(armee[1]);
	System.out.println(armee[0].tirer());
	System.out.println(armee[1].tirer());
	System.out.println(armee[0].deplacer());
	System.out.println(armee[1].deplacer());
	System.out.println(armee[0].getFiche());
	System.out.println(armee[1].getFiche());
	
	System.out.println("Les units acquierent un don special");
	armee[0] = new UniteEspion(armee[0]);
	armee[1] = new UniteEspion(armee[1]);
	System.out.println(armee[0].tirer());
	System.out.println(armee[1].tirer());
	System.out.println(armee[0].deplacer());
	System.out.println(armee[1].deplacer());
	System.out.println(armee[0].getFiche());
	System.out.println(armee[1].getFiche());

	
	System.out.println("Fin partie");
    }
}
