package patternstrategy;

interface ConstantesArmes {
	public static final int PISTOLET = 1;
	public static final int FUSIL = 2;
	public static final int BAZOOKA = 3;
}

class UniteCombat implements ConstantesArmes {
    protected int point_vie;
    protected int arme;
    
    public void deplacer() {
    }
    public void tirer() {
    }
    public void setArme(int arme) {
	this.arme = arme;
    }
}

class  Avion extends UniteCombat {
    Avion() {
	point_vie = 100;
    }
    
    public void deplacer() {
	System.out.println("Avion: Je vole");
    }
    public void tirer() {
	System.out.println("Avion: Je bombarde");
    }
}

class  SousMarin extends UniteCombat {
    SousMarin() {
	point_vie = 1000;
    }
    
    public void deplacer() {
	System.out.println("Sous-Marin: Je plonge");
    }
    public void tirer() {
	System.out.println("Sous-Marin: Je torpille l'ennemi");
    }
}

/*
class  Soldat extends UniteCombat {
    Soldat() {
	point_vie = 10;
    }
    
    public void deplacer() {
	System.out.println("Soldat: Je me deplace a pied");
    }
    public void tirer() {
	System.out.println("Soldat: Je tire avec un fusil");
    }
}
*/


class  Soldat extends UniteCombat {
    
    Soldat() {
	point_vie = 10;
	arme = ConstantesArmes.FUSIL;
    }
    
    public void deplacer() {
	System.out.println("Soldat: Je me deplace a pied");
    }
    public void tirer() {
	switch(arme) {
	    case PISTOLET:
		System.out.println("Soldat: Je tire avec un pistolet");
		break;
	    case FUSIL:
		System.out.println("Soldat: Je tire avec un fusil");
		break;
	    case BAZOOKA:
		System.out.println("Soldat: Je tire avec un bazooka");
		break;
	    default:
		System.out.println("Soldat: je suis pris en defaut completement desarme");
		break;
	}
    }
}

public class MauvaiseTactique {
    public static void main(String[] args) {
	System.out.println("Debut partie");
	UniteCombat[] armee = new UniteCombat[3];
	armee[0] = new Soldat();
	armee[1] = new Avion();
	armee[2] = new SousMarin();
	for(UniteCombat uc : armee) {
	    uc.deplacer();
	    uc.tirer();
	}
	
	armee[0].setArme(ConstantesArmes.PISTOLET);
	armee[0].tirer();
	armee[0].setArme(ConstantesArmes.BAZOOKA);
	armee[0].tirer();	
	System.out.println("Fin partie");
    }
}
