package fred;

import java.io.FileOutputStream;
import java.awt.Color;

import com.lowagie.text.Rectangle;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.HtmlWriter;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter2;

public class HelloWorld {
	  public static void main(String[] args) {
		  final float marge = 100.0f;
		  // Dfinir le rectangle englobant chaque page
		  Rectangle rect =  PageSize.A4;
		  rect.setBackgroundColor(Color.LIGHT_GRAY);
		  rect.setBorder(Rectangle.LEFT| Rectangle.RIGHT
				  | Rectangle.TOP| Rectangle.BOTTOM);
		  rect.setBorderColor(Color.BLACK);
		  rect.setBorderWidth(10.0f);
		  
		  // Crer le document lui mme, en dfinissant une marge
		  Document document = new Document(rect, marge, marge, marge, marge);    	
		  try { 
			  	// cration des writers 
			  	HtmlWriter.getInstance(document,
			  			new FileOutputStream("helloworld.html"));
			  	PdfWriter.getInstance(document,
			  			new FileOutputStream("helloworld.pdf"));
			  	PdfWriter.getInstance(document, System.out);
	    	  	 RtfWriter2.getInstance(document,
	    	  			 new FileOutputStream("helloworld.rtf"));  	   	  
	    	   // Quelques mta-donnes
	    	   document.addAuthor("Fred");
	    	   document.addCreator("Programmez!");
	    	   document.addSubject("Hello World gnr avec iText");
	    	   document.addTitle("HelloWorld -- Programmez!");
	    	   
	    	   document.open(); 
	    	   document.add(new Paragraph("Programmez!"));
	    	   document.add(new Paragraph("Abonnez vous :-)"));
	    	   
	    	  } catch(Exception e) {
	    	   System.err.println(e.getMessage());
	    	  }
	    	  finally {
	    		  document.close();
	    	  }
	    }
}
