package fred;

import java.awt.Color;
import java.io.FileOutputStream;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Chunk;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.rtf.RtfWriter2;

public class Programmez {
	public static void main(String[] args) {
		Document document = new Document(PageSize.A4,
				50.0f, 50.0f, 50.0f, 50.0f);
		
		try {
			PdfWriter.getInstance(document,
					new FileOutputStream("programmez.pdf"));
			RtfWriter2.getInstance(document ,
					new FileOutputStream("programmez.rtf"));
			document.addAuthor("Fred");
			document.addCreator("Programmez!");
			document.addSubject("Magazine Programmez!");
			document.addTitle("Prsentation");
			
			document.open();
			
			Image image = Image.getInstance("logo_programmez.jpg");
			image.setAlignment(Image.ALIGN_LEFT);
			image.scaleAbsolute(400.0f, 112.0f);

			document.add(image);
			
			/*
			 * Ici, mauvaise mthode, la phrase 
			 * chevaucherait l'image
			 
			Phrase phrase = new Phrase(
					"Le magazine du dveloppement",
					FontFactory.getFont(FontFactory.TIMES, 24,
							Font.BOLDITALIC, new Color(0, 0, 0)));
			document.add(phrase);
			*/
			
			Paragraph paragraph = new Paragraph(
					"Le magazine du dveloppement",
					FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
							Font.BOLDITALIC, new Color(0, 0, 0)));
			document.add(paragraph);
  	   
			paragraph = new Paragraph();
			paragraph.setSpacingBefore(10.0f);
			Chunk chunk = new Chunk("Abonnez vous!",
					FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
							Font.BOLDITALIC, new Color(255, 0, 0)));
			paragraph.add(chunk);
			chunk = new Chunk(";-)",
					FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
							Font.BOLDITALIC, new Color(0, 0, 255)));
			paragraph.add(chunk);
			document.add(paragraph);						
			
  	  } catch(Exception e) {
  	   System.err.println(e.getMessage());
  	  }
  	  finally {
  		  document.close();
  	  }
	}
}
