package fred;

import java.awt.Color;
import java.io.FileOutputStream;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Chunk;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Table;
import com.lowagie.text.rtf.RtfWriter2;
import com.lowagie.text.rtf.table.RtfBorderGroup;
import com.lowagie.text.rtf.table.RtfBorder;
import com.lowagie.text.rtf.table.RtfCell;


public class ProgrammezRTF {
	
	public static void main(String[] args) {
		Document document = new Document(PageSize.A4,
				50.0f, 50.0f, 50.0f, 50.0f);
		
		try {
			RtfWriter2.getInstance(document,
					new FileOutputStream("programmez-table.rtf"));
			document.addAuthor("Fred");
			document.addCreator("Programmez!");
			document.addSubject("Magazine Programmez!");
			document.addTitle("Prsentation");
			
			document.open();
			
			Image image = Image.getInstance("logo_programmez.jpg");
			image.setAlignment(Image.ALIGN_LEFT);

			document.add(image);


			Paragraph paragraph = new Paragraph(
					"Le magazine du dveloppement",
					FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
							Font.BOLDITALIC, new Color(0, 0, 0)));
			paragraph.setSpacingBefore(20.0f);
			paragraph.setSpacingAfter(10.0f);
			document.add(paragraph);

			paragraph.setSpacingBefore(20.0f);
			paragraph.setSpacingAfter(10.0f);

			paragraph = new Paragraph();
			paragraph.setSpacingBefore(10.0f);
			paragraph.setSpacingAfter(20.0f);
			Chunk chunk = new Chunk("Abonnez vous!",
					FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
							Font.BOLDITALIC, new Color(255, 0, 0)));

			paragraph.add(chunk);
			chunk = new Chunk(";-)",
					FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
							Font.BOLDITALIC, new Color(0, 0, 255)));
			paragraph.add(chunk);
			chunk = new Chunk("",
					FontFactory.getFont(FontFactory.TIMES, 24,
							Font.NORMAL, new Color(0, 0, 0)));
			paragraph.add(chunk);
			document.add(paragraph);
			
			Table table = new Table(2);
			table.setBorderWidth(20.0f);
			table.setPadding(5.0f);
			table.setSpacing(5.0f);
			
			RtfCell rtfcell = new RtfCell("L'quipe");
			rtfcell.setBorders(new RtfBorderGroup(
					Rectangle.BOX, RtfBorder.BORDER_DOUBLE_WAVY,
					5.0f, new Color(0, 0, 0)));
			rtfcell.setColspan(2);
			rtfcell.setHeader(true);
			table.addCell(rtfcell);
			table.endHeaders();
			
			
			rtfcell = new RtfCell("Jean");
			rtfcell.setBorders(new RtfBorderGroup(
					Rectangle.BOX, RtfBorder.BORDER_STRIPED,
					1.0f, new Color(0, 0, 0)));
			table.addCell(rtfcell);

			rtfcell = new RtfCell("Kaminsky");
			rtfcell.setBorders(new RtfBorderGroup(
					Rectangle.BOX, RtfBorder.BORDER_STRIPED,
					1.0f, new Color(0, 0, 0)));
			table.addCell(rtfcell);

			rtfcell = new RtfCell("Franois");
			rtfcell.setBorders(new RtfBorderGroup(
					Rectangle.BOX, RtfBorder.BORDER_DOUBLE,
					1.0f, new Color(0, 0, 0)));
			table.addCell(rtfcell);

			rtfcell = new RtfCell("Tonic");
			rtfcell.setBorders(new RtfBorderGroup(
					Rectangle.BOX, RtfBorder.BORDER_DOUBLE,
					1.0f, new Color(0, 0, 0)));
			table.addCell(rtfcell);
			
			rtfcell = new RtfCell("Sbastien");
			rtfcell.setBorders(new RtfBorderGroup(
					Rectangle.BOX, RtfBorder.BORDER_SINGLE,
					1.0f, new Color(0, 0, 0)));
			table.addCell(rtfcell);
			
			rtfcell = new RtfCell("Develay");
			rtfcell.setBorders(new RtfBorderGroup(
					Rectangle.BOX, RtfBorder.BORDER_SINGLE,
					1.0f, new Color(0, 0, 0)));
			table.addCell(rtfcell);
			
			rtfcell = new RtfCell("Frdric");
			rtfcell.setBorders(new RtfBorderGroup(
					Rectangle.BOX, RtfBorder.BORDER_DOTTED,
					1.0f, new Color(0, 0, 0)));
			table.addCell(rtfcell);
			
			rtfcell = new RtfCell("Mazu");
			rtfcell.setBorders(new RtfBorderGroup(
					Rectangle.BOX, RtfBorder.BORDER_DOTTED,
					1.0f, new Color(0, 0, 0)));
			table.addCell(rtfcell);
			document.add(table);
			
  	  } catch(Exception e) {
  	   System.err.println(e.getMessage());
  	  }
  	  finally {
  		  document.close();
  	  }
}
}
