#include "COMUtils.h"
#include <sapi.h>
#include <iostream>

const ULONGLONG grammarID = 1;

void Run()
{
	HRESULT hr;
	SmartCOMPtr<ISpRecognizer> recognizer;
	SmartCOMPtr<ISpRecoContext> reco_context;
	SmartCOMPtr<ISpRecoGrammar> reco_grammar;
	HANDLE event;
	ULONGLONG interest;


	hr = ::CoCreateInstance(
		CLSID_SpSharedRecognizer, 
		NULL,
		CLSCTX_ALL,
		IID_ISpRecognizer,
		reinterpret_cast<void**>(&recognizer));
	COMHelper::TestOk(hr);
	
	hr = recognizer->CreateRecoContext(&reco_context);
	COMHelper::TestOk(hr);

	// ou mme directement
	/*
	hr = ::CoCreateInstance(
		CLSID_SpSharedRecoContext, 
		NULL,
		CLSCTX_ALL,
		IID_ISpRecoContext,
		reinterpret_cast<void**>(&reco_context));
	COMHelper::TestOk(hr);
	*/

	hr = reco_context->CreateGrammar(grammarID, &reco_grammar);
	COMHelper::TestOk(hr);
	
	hr = reco_grammar->LoadDictation(NULL, SPLO_STATIC);
	COMHelper::TestOk(hr);

	hr = reco_context->SetNotifyWin32Event();
	COMHelper::TestOk(hr);
	
	event = reco_context->GetNotifyEventHandle();
	if(event == INVALID_HANDLE_VALUE)
		COMHelper::TestOk(E_FAIL);

	std::cout << "Vous devez peut etre dire:"
		" commencer l'ecoute" << std::endl;
	// Si ci-dessous non invoque, le moteur de reconnaissance dmarre
	// normalement, mais nous ne sommes jamais notifis de rien
	interest = SPFEI(SPEI_RECOGNITION);
	hr = reco_context->SetInterest(interest, interest);
	COMHelper::TestOk(hr);
	// lancer l'coute
	hr = reco_grammar->SetDictationState(SPRS_ACTIVE);
	COMHelper::TestOk(hr);


	// Attendre la reconnaissance d'un mot	
	HANDLE tab_handle[1];
	tab_handle[0] = event;
	::WaitForMultipleObjects(1, tab_handle, FALSE, INFINITE);
	std::cout << "J'ai entendu quelque chose" << std::endl;
	hr = reco_grammar->SetDictationState(SPRS_INACTIVE);
	std::cout << "Maintenant je me bouche les oreilles" << std::endl;
	std::cout <<  "Bye, bye" << std::endl;
}

int main(int argc, char** argv)
{
	try
	{
		COMInitializer ci;
		Run();
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
