#include "COMUtils.h"
#include <sapi.h>
#include <iostream>

const ULONGLONG grammarID = 1;


void GetText(SmartCOMPtr<ISpRecoContext> reco_context)
{
	const ULONG max_events = 10;
	ULONG nb_events;
	SPEVENT les_events[max_events]; // voir la dclaration de SPEVENT dans sapi.h est TRES instructif
	HRESULT hr;
	SmartCOMPtr<ISpRecoResult> reco_result;

	hr = reco_context->GetEvents(max_events, les_events, &nb_events);
	// Attention hr vaut S_FALSE si tout va bien mais
	// que le nombre d'vnements obtenus est infrieur
	// au nombre d'vnements demands
	if(!(hr == S_OK || hr == S_FALSE))
		COMHelper::TestOk(hr);
	std::cout << "Nb events: " << nb_events << std::endl;
	*(&reco_result) = reinterpret_cast<ISpRecoResult*>(les_events[0].lParam);

	WCHAR* le_texte;
	hr = reco_result->GetText(
		SP_GETWHOLEPHRASE, SP_GETWHOLEPHRASE, FALSE, &le_texte, NULL);
	COMHelper::TestOk(hr);
	std::wcout << "J'ai compris: " << le_texte << std::endl;
	::CoTaskMemFree(le_texte);
	
	std::cout << "Alternatives:" << std::endl << std::endl;
	const ULONG max_alternates = 30;
	ULONG nb_alternates;
	ISpPhraseAlt* alternatives[max_alternates];
	reco_result->GetAlternates(0, SPPR_ALL_ELEMENTS,
		max_alternates, alternatives, &nb_alternates);

	std::cout << "Nombre: " << nb_alternates << std::endl;
	for(int i=0; i<nb_alternates; i++)
	{
		WCHAR* texte_alternatif;
		SmartCOMPtr<ISpPhraseAlt> phrase_alt;
		*(&phrase_alt) = alternatives[i];
		phrase_alt->GetText(
			SP_GETWHOLEPHRASE, SP_GETWHOLEPHRASE, FALSE, &texte_alternatif, NULL);
		std::wcout << "Alternative: " << texte_alternatif << std::endl;
		::CoTaskMemFree(texte_alternatif);
	}	
}

void Run()
{
	HRESULT hr;
	SmartCOMPtr<ISpRecognizer> recognizer;
	SmartCOMPtr<ISpRecoContext> reco_context;
	SmartCOMPtr<ISpRecoGrammar> reco_grammar;
	HANDLE event;
	ULONGLONG interest;


	hr = ::CoCreateInstance(
		CLSID_SpSharedRecognizer, 
		NULL,
		CLSCTX_ALL,
		IID_ISpRecognizer,
		reinterpret_cast<void**>(&recognizer));
	COMHelper::TestOk(hr);
	
	hr = recognizer->CreateRecoContext(&reco_context);
	COMHelper::TestOk(hr);


	hr = reco_context->CreateGrammar(grammarID, &reco_grammar);
	COMHelper::TestOk(hr);
	
	hr = reco_grammar->LoadDictation(NULL, SPLO_STATIC);
	COMHelper::TestOk(hr);

	hr = reco_context->SetNotifyWin32Event();
	COMHelper::TestOk(hr);
	
	event = reco_context->GetNotifyEventHandle();
	if(event == INVALID_HANDLE_VALUE)
		COMHelper::TestOk(E_FAIL);

	std::cout << "Vous devez peut etre dire:"
		" commencer l'ecoute" << std::endl;
	// Si ci-dessous non invoque, le moteur de reconnaissance dmarre
	// normalement, mais nous ne sommes jamais notifis de rien
	interest = SPFEI(SPEI_RECOGNITION);
	hr = reco_context->SetInterest(interest, interest);
	COMHelper::TestOk(hr);
	// lancer l'coute
	hr = reco_grammar->SetDictationState(SPRS_ACTIVE);
	COMHelper::TestOk(hr);


	// Attendre la reconnaissance d'un mot	
	HANDLE tab_handle[1];
	tab_handle[0] = event;
	::WaitForMultipleObjects(1, tab_handle, FALSE, INFINITE);
	std::cout << "J'ai entendu quelque chose" << std::endl;
	GetText(reco_context);
	hr = reco_grammar->SetDictationState(SPRS_INACTIVE);
	std::cout << "Maintenant je me bouche les oreilles" << std::endl;
	std::cout <<  "Bye, bye" << std::endl;
}

int main(int argc, char** argv)
{
	try
	{
		COMInitializer ci;
		Run();
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
