#include "COMUtils.h"
#include <sapi.h>
#include <iostream>

const ULONGLONG grammarExitID = 1;
const WCHAR* ruleExitName = L"RegleQuitter";

const ULONGLONG grammarCountID = 2;
const WCHAR* ruleCountName = L"RegleCompter";


void GetText(SmartCOMPtr<ISpRecoContext> reco_context)
{
	const ULONG max_events = 10;
	ULONG nb_events;
	SPEVENT les_events[max_events]; // voir la dclaration de SPEVENT dans sapi.h, TRES instructif
	HRESULT hr;
	SmartCOMPtr<ISpRecoResult> reco_result;

	hr = reco_context->GetEvents(max_events, les_events, &nb_events);
	// Attention hr vaut S_FALSE si tout va bien mais
	// que le nombre d'vnements obtenus est infrieur
	// au nombre d'vnements demands
	if(!(hr == S_OK || hr == S_FALSE))
		COMHelper::TestOk(hr);
	std::cout << "Nb events: " << nb_events << std::endl;
	*(&reco_result) = reinterpret_cast<ISpRecoResult*>(les_events[0].lParam);

	WCHAR* le_texte;
	hr = reco_result->GetText(
		SP_GETWHOLEPHRASE, SP_GETWHOLEPHRASE, FALSE, &le_texte, NULL);
	COMHelper::TestOk(hr);
	std::wcout << "J'ai compris: " << le_texte << std::endl;
	::CoTaskMemFree(le_texte);
}

SmartCOMPtr<ISpRecoGrammar>
InstallGrammarCount(SmartCOMPtr<ISpRecoContext> reco_context)
{
	HRESULT hr;
	SPSTATEHANDLE hStateCountOne, hStateCountTwo, hStateCountThree;
	SmartCOMPtr<ISpRecoGrammar> reco_grammar;

	hr = reco_context->CreateGrammar(grammarCountID, &reco_grammar);
	COMHelper::TestOk(hr);

	hr = reco_grammar->ResetGrammar(GetUserDefaultUILanguage());
	COMHelper::TestOk(hr);

	// Crer une rgle
	// On commence par crer les trois tats successifs
	hr = reco_grammar->GetRule(ruleCountName, 0, SPRAF_TopLevel | SPRAF_Active, TRUE, &hStateCountOne);
	COMHelper::TestOk(hr);
	hr = reco_grammar->CreateNewState(hStateCountOne, &hStateCountTwo);
	COMHelper::TestOk(hr);
	hr = reco_grammar->CreateNewState(hStateCountTwo, &hStateCountThree);
	COMHelper::TestOk(hr);

	
	// Ajouter un
	hr = reco_grammar->AddWordTransition(
		hStateCountOne, hStateCountTwo, L"Un", L" ", SPWT_LEXICAL, 1, NULL);
	COMHelper::TestOk(hr);
	// Ajouter deux
	hr = reco_grammar->AddWordTransition(
		hStateCountTwo, hStateCountThree, L"Deux", L" ", SPWT_LEXICAL, 1, NULL);
	COMHelper::TestOk(hr);
	// Ajouter deux
	hr = reco_grammar->AddWordTransition(
		hStateCountThree, NULL, L"Trois", L" ", SPWT_LEXICAL, 1, NULL);
	COMHelper::TestOk(hr);

	// Trs important,
	// sinon rien est fait 
	hr = reco_grammar->Commit(0);
	COMHelper::TestOk(hr);

	return reco_grammar;
}

SmartCOMPtr<ISpRecoGrammar>
InstallGrammarExit(SmartCOMPtr<ISpRecoContext> reco_context)
{
	HRESULT hr;
	SPSTATEHANDLE hStateQuitter;
	SmartCOMPtr<ISpRecoGrammar> reco_grammar;

	hr = reco_context->CreateGrammar(grammarExitID, &reco_grammar);
	COMHelper::TestOk(hr);

	hr = reco_grammar->ResetGrammar(GetUserDefaultUILanguage());
	COMHelper::TestOk(hr);

	// Crer une rgle
	hr = reco_grammar->GetRule(ruleExitName, 0, SPRAF_TopLevel | SPRAF_Active, TRUE, &hStateQuitter);
	COMHelper::TestOk(hr);
	// Ajouter un mot
	hr = reco_grammar->AddWordTransition(
		hStateQuitter, NULL, L"Quitter", L" ", SPWT_LEXICAL, 1, NULL);
	COMHelper::TestOk(hr);

	// Trs important,
	// sinon rien est fait 
	hr = reco_grammar->Commit(0);
	COMHelper::TestOk(hr);

	return reco_grammar;
}

void Run()
{
	HRESULT hr;
	SmartCOMPtr<ISpRecognizer> recognizer;
	SmartCOMPtr<ISpRecoContext> reco_context_exit;
	SmartCOMPtr<ISpRecoContext> reco_context_count;
	SmartCOMPtr<ISpRecoGrammar> reco_grammar_exit;
	SmartCOMPtr<ISpRecoGrammar> reco_grammar_count;
	HANDLE event_exit, event_count;
	ULONGLONG interest;

	hr = ::CoCreateInstance(
		CLSID_SpSharedRecognizer, 
		NULL,
		CLSCTX_ALL,
		IID_ISpRecognizer,
		reinterpret_cast<void**>(&recognizer));
	COMHelper::TestOk(hr);
	
	hr = recognizer->CreateRecoContext(&reco_context_exit);
	COMHelper::TestOk(hr);

	hr = recognizer->CreateRecoContext(&reco_context_count);
	COMHelper::TestOk(hr);

	std::cout << "Vous devez peut etre dire:"
		" commencer l'ecoute" << std::endl;
	std::cout << "Puis commencez a compter: un, deux, trois" << std::endl;

	// Dsactiver les contextes
	hr = reco_context_exit->Pause(0);
	COMHelper::TestOk(hr);
	hr = reco_context_count->Pause(0);
	COMHelper::TestOk(hr);

	reco_grammar_exit = InstallGrammarExit(reco_context_exit);
	reco_grammar_count = InstallGrammarCount(reco_context_count);


	// Obtenir les objets de synchronisation
	// pour les venements de reconnaissance
	hr = reco_context_exit->SetNotifyWin32Event();
	COMHelper::TestOk(hr);
	event_exit = reco_context_exit->GetNotifyEventHandle();
	if(event_exit == INVALID_HANDLE_VALUE)
		COMHelper::TestOk(E_FAIL);
	hr = reco_context_count->SetNotifyWin32Event();
	COMHelper::TestOk(hr);
	event_count = reco_context_count->GetNotifyEventHandle();
	if(event_count == INVALID_HANDLE_VALUE)
		COMHelper::TestOk(E_FAIL);
	// Si ci-dessous non invoque, le moteur de reconnaissance dmarre
	// normalement, mais nous ne sommes jamais notifis de rien
	interest = SPFEI(SPEI_RECOGNITION);
	hr = reco_context_exit->SetInterest(interest, interest);
	COMHelper::TestOk(hr);
	hr = reco_context_count->SetInterest(interest, interest);
	COMHelper::TestOk(hr);
	// activer ou non les grammaires
	hr = reco_grammar_exit->SetRuleState(ruleExitName, 0, SPRS_INACTIVE);
	COMHelper::TestOk(hr);
	hr = reco_grammar_count->SetRuleState(ruleCountName, 0, SPRS_ACTIVE);
	COMHelper::TestOk(hr);
	// Ractiver les contextes
	hr = reco_context_exit->Resume(0);
	COMHelper::TestOk(hr);
	hr = reco_context_count->Resume(0);
	COMHelper::TestOk(hr);
	// Attendre la reconnaissance du compte
	HANDLE tab_handle[1];
	tab_handle[0] = event_count;
	::WaitForMultipleObjects(1, tab_handle, FALSE, INFINITE);
	GetText(reco_context_count);
	// On dsactive la rgle de reconnaissance de compte
	hr = reco_grammar_count->SetRuleState(ruleCountName, 0, SPRS_INACTIVE);
	// Et on active l'autre pour quitter
	hr = reco_grammar_exit->SetRuleState(ruleExitName, 0, SPRS_ACTIVE);
	// Attendre la reconnaissance de quitter
	tab_handle[0] = event_exit;
	::WaitForMultipleObjects(1, tab_handle, FALSE, INFINITE);
	GetText(reco_context_exit);

	std::cout << "Maintenant je me bouche les oreilles" << std::endl;
	std::cout <<  "Bye, bye" << std::endl;
}

int main(int argc, char** argv)
{
	try
	{
		COMInitializer ci;
		Run();
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
