[System.Reflection.Assembly]::LoadWithPartialName("System.windows.forms") | out-null

function run ([string]$wmicl)
{
	$wmiform = new-object Windows.Forms.Form    
	$wmiform.size = "600, 500" 
	$button = new-object System.Windows.Forms.Button 
	$button.text = "Fermer"
	$button.location = "260, 420"
	$button.add_Click(
		{ 
			$wmiform.Close()
		})  

	$wmiform.Controls.Add($button)  
	# Faire du bouton un bouton par dfaut
	$wmiform.AcceptButton =  $button   

	$tb = new-object Windows.Forms.TextBox
	$tb.location = "10, 10"
	$tb.multiline = 1
	$tb.size = "570, 400"
	$tb.scrollbars = [System.windows.forms.Scrollbars]::Vertical
	$wmiform.Controls.Add($tb)

	$management_class = new-object system.management.managementclass $wmicl
	$all_instances = $management_class.psbase.GetInstances()
	foreach($inst in $all_instances)
	{	
		$tb.appendtext("------------------------------------------")
		$tb.appendtext([Environment]::newline)
		$tb.appendtext($inst.name)
		$tb.appendtext([Environment]::newline)
		$tb.appendtext("------------------------------------------")
		$tb.appendtext([Environment]::newline)


		$inst_prop_all = $inst.psbase.Properties
		foreach($inst_prop in $inst_prop_all)
		{
			$prop = $inst_prop.Name
			$prop += " = "
			$prop += $inst_prop.Value
			$tb.appendtext($prop)
			$tb.appendtext([Environment]::newline)
		}
	}

	$wmiform.showdialog() | out-null
}

run $args[0]