REBOL [
    Title: "Args"
    Date: 7-Aug-2008
    File: %args.r
    Author: "Fred"
    Version: 1.0
    Purpose: {Manipulation des arguments de la ligne
	de commande 
	options connues: -h --verbose=on|off }
]

verbose: off

get-verbose: func [
    "Traite l'option --verbose dans une chaine d'options "
    all-args [block!] "Les options passes au script"
	/local largs value
][
    foreach element all-args [
		if find element "--verbose=" [
			largs: parse element "="
			either equal? length? largs 2 [
				value: pick largs 2
				if not or equal? value "on" equal? value "off" [
					print "Les valeurs de l'option --verbose sont on ou off"
					print "Arret"
					quit
				]
				verbose: value
			][
				print "Option verbose mal formee"
			]
		] ; fin if
	]
]

get-help: func [
    "Traite l'option -h dans une chaine d'options "
    all-args [block!] "Les options passes au script"

][
	foreach element all-args [
		if element = "-h" [
			print "Ceci est un texte d'aide: Programmez! Abonnez vous :-)"
		]
	]
]

process-options: func [
    "Applique des fonctions de traitement aux options passes au scripts"
	fonctions [block!] "Les fonctions de traitement"
    all-args [block!] "Les options passes au script"
][
	foreach fonction fonctions [
		do fonction all-args
	]
]

process-options [get-verbose get-help] parse system/script/args none
prin "verbose: " print verbose


