require 'opengl'
require 'glut'

WIDTH = 300
HEIGHT = 300
X_INIT = 100
Y_INIT = 100

$liste_affichage = 0
$angle = 0.0
$eloignement_maxi = -49.0
$eloignement_mini = -12.0
$eloignement = $eloignement_mini
$pas = 0.2
$sens  = true


display = proc {
  GL.Clear(GL::COLOR_BUFFER_BIT)
	
	GL.LoadIdentity()
	GL.Translate(0.0, 0.0, $eloignement)
	GL.Rotate($angle, 0.0, 1.0, 0.0) 
	GL.CallList($liste_affichage)
	GLUT.SwapBuffers()
  
  $angle = $angle + 1.0
	if $angle > 360.0
		$angle = 0.0
  end
	
	if $sens == true
		$eloignement -= $pas
		if $eloignement < $eloignement_maxi
			$sens = false
    end
	else
		$eloignement += $pas
		if $eloignement > $eloignement_mini
			$sens = true
    end
	end	
}



def create_list()
  
  $liste_affichage = GL.GenLists(1)
  GL.NewList($liste_affichage, GL::COMPILE)
    # ici le contenu de
    # la liste d'affichage
    GL.Begin(GL::TRIANGLES)
      GL.Color3f(1.0, 0.0, 1.0)
      GL.Vertex3f(0.0, 0.5, 0.0)
      GL.Color3f(1.0, 1.0, 0.0);
      GL.Vertex3f(-0.75, -0.5, 0.0)
      GL.Color3f(0.0, 1.0, 1.0)
      GL.Vertex3f(0.75, -0.5, 0.0)
    GL.End()
  GL.EndList()
end

def init()
   GL.ClearColor(0.0, 0.0, 0.0, 0.0)
   GL.ShadeModel(GL::SMOOTH)
   create_list()
end

idle = proc {
  GLUT.PostRedisplay()
}

visible = proc{|visible|
  if visible == GLUT::VISIBLE
    GLUT.IdleFunc(idle)
  else
    GLUT.IdleFunc(nil)
  end
}

keyboard = proc {|key, x, y|
   case (key)
   when 27:
    puts "Programmez!, abonnez vous :)"
    exit(0)
  else
    printf("%c\n", key)
   end
}

mouse = proc {|button, state, x, y|
  case(state)
    when 1: # si bouton enfonc
    case (button)
      when GLUT::LEFT_BUTTON:
      printf("X = %d, Y = %d\n", x,  y)
    end
  end
}

reshape = proc { |width, height|
	GL.Viewport(0, 0, width, height)
  GL.MatrixMode(GL::PROJECTION)
  GL.LoadIdentity()
  GL.Frustum(-1.0, 1.0, -1.0, 1.0, 10.0, 50.0)
  GL.MatrixMode(GL::MODELVIEW)
}

GLUT.Init()
GLUT.InitDisplayMode(GLUT::RGB | GLUT::DEPTH | GLUT::DOUBLE)
GLUT.InitWindowSize(WIDTH, HEIGHT)
GLUT.InitWindowPosition(X_INIT, Y_INIT)
GLUT.CreateWindow()
init()
GLUT.DisplayFunc(display)
GLUT.KeyboardFunc(keyboard)
GLUT.MouseFunc(mouse)
GLUT.ReshapeFunc(reshape)
GLUT.VisibilityFunc(visible)
GLUT.MainLoop()
