require 'opengl'
require 'glut'

include Math

WIDTH = 300
HEIGHT = 300
X_INIT = 100
Y_INIT = 100

$angle = 0.0
$eloignement_maxi = -49.0
$eloignement_mini = -12.0
$eloignement = $eloignement_mini
$pas = 0.2
$sens  = true

$vertices = 0
$couleurs = 0
$indices = 0

display = proc {
  GL.Clear(GL::COLOR_BUFFER_BIT)
	
	GL.LoadIdentity()
	GL.Translate(0.0, 0.0, $eloignement)
	GL.Rotate($angle, 0.0, 1.0, 0.0) 
	
  GL.DrawElements(GL::POLYGON, 8, GL::UNSIGNED_INT, $indices)
	GLUT.SwapBuffers()
  
  $angle = $angle + 1.0
	if $angle > 360.0
		$angle = 0.0
  end
	
	if $sens == true
		$eloignement -= $pas
		if $eloignement < $eloignement_maxi
			$sens = false
    end
	else
		$eloignement += $pas
		if $eloignement > $eloignement_mini
			$sens = true
    end
	end	
}


def prepare_array()
  points = 
  [
    [cos(PI/6.0), sin(PI/6.0)],
    [cos(PI/3.0), sin(PI/3.0)],
    [-cos(PI/3.0), sin(PI/3.0)],
    [-cos(PI/6.0), sin(PI/6.0)],
    [-cos(PI/6.0), -sin(PI/6.0)],
    [-cos(PI/3.0), -sin(PI/3.0)],
    [cos(PI/3.0), -sin(PI/3.0)],
    [cos(PI/6.0), -sin(PI/6.0)]
  ]

  $vertices = points.flatten()
  $vertices = $vertices.pack("f*")
  
  $couleurs =
  [
    [1.0, 0.0, 1.0],
    [1.0, 1.0, 0.0]
  ]

  $couleurs += $couleurs
  $couleurs += $couleurs
  # et non pas simplement couleurs.flatten() !! ;-)
  $couleurs = $couleurs.flatten()
  $couleurs = $couleurs.pack("f*")
  
  $indices = (0..7)
  $indices = $indices.to_a()
  # I pour unsigned int obligatoirement 
  # car requis par GL.DrawElements
  $indices = $indices.pack("I*")
  
  GL.EnableClientState(GL::VERTEX_ARRAY)
  GL.EnableClientState(GL::COLOR_ARRAY)

  GL.VertexPointer(2, GL::FLOAT, 0, $vertices)
  GL.ColorPointer(3, GL::FLOAT, 0, $couleurs)
end

def init()
   GL.ClearColor(0.0, 0.0, 0.0, 0.0)
   GL.ShadeModel(GL::SMOOTH)
   prepare_array()
end

idle = proc {
  GLUT.PostRedisplay()
}

visible = proc{|visible|
  if visible == GLUT::VISIBLE
    GLUT.IdleFunc(idle)
  else
    GLUT.IdleFunc(nil)
  end
}

keyboard = proc {|key, x, y|
   case (key)
   when 27:
    puts "Programmez!, abonnez vous :)"
    exit(0)
  else
    printf("%c\n", key)
   end
}

mouse = proc {|button, state, x, y|
  case(state)
    when 1: # si bouton enfonc
    case (button)
      when GLUT::LEFT_BUTTON:
      printf("X = %d, Y = %d\n", x,  y)
    end
  end
}

reshape = proc { |width, height|
	GL.Viewport(0, 0, width, height)
  GL.MatrixMode(GL::PROJECTION)
  GL.LoadIdentity()
  GL.Frustum(-1.0, 1.0, -1.0, 1.0, 10.0, 50.0)
  GL.MatrixMode(GL::MODELVIEW)
}

GLUT.Init()
GLUT.InitDisplayMode(GLUT::RGB | GLUT::DEPTH | GLUT::DOUBLE)
GLUT.InitWindowSize(WIDTH, HEIGHT)
GLUT.InitWindowPosition(X_INIT, Y_INIT)
GLUT.CreateWindow()
init()
GLUT.DisplayFunc(display)
GLUT.KeyboardFunc(keyboard)
GLUT.MouseFunc(mouse)
GLUT.ReshapeFunc(reshape)
GLUT.VisibilityFunc(visible)
GLUT.MainLoop()
