require 'opengl'
require 'glut'

WIDTH = 300
HEIGHT = 300
X_INIT = 100
Y_INIT = 100

$fogMode = 0
$fogColor = []
$liste_affichage = 0
$angle = 0.0
$eloignement_maxi = -49.0
$eloignement_mini = -12.0
$eloignement = $eloignement_mini
$pas = 0.2
$sens  = true


display = proc {
  GL.Clear(GL::COLOR_BUFFER_BIT)
	
	GL.LoadIdentity()
	GL.Translate(0.0, 0.0, $eloignement)
	GL.Rotate($angle, 0.0, 1.0, 0.0) 
	GL.CallList(1)
	GLUT.SwapBuffers()
  
  $angle = $angle + 1.0
	if $angle > 360.0
		$angle = 0.0
  end
	
	if $sens == true
		$eloignement -= $pas
		if $eloignement < $eloignement_maxi
			$sens = false
    end
	else
		$eloignement += $pas
		if $eloignement > $eloignement_mini
			$sens = true
    end
	end	
}



def create_list()
  liste_affichage = GL.GenLists(1)
  GL.NewList(liste_affichage, GL::COMPILE)
    # ici le contenu de
    # la liste d'affichage
    GL.Begin(GL::TRIANGLES)
      GL.Color3f(1.0, 0.0, 1.0)
      GL.Vertex3f(0.0, 0.5, 0.0)
      GL.Color3f(1.0, 1.0, 0.0);
      GL.Vertex3f(-0.75, -0.5, 0.0)
      GL.Color3f(0.0, 1.0, 1.0)
      GL.Vertex3f(0.75, -0.5, 0.0)
    GL.End()
  GL.EndList()
end

def init()
   GL.ClearColor(0.0, 0.0, 0.0, 0.0)
   GL.ShadeModel(GL::SMOOTH)
   # Cration de la liste d'affichage
  create_list()
   
  # Initialisation du brouillard
  GL.Enable(GL::FOG)
  $fogColor = [0.5, 0.5, 0.5, 1.0]
  $fogMode = GL::EXP
  GL.Fog(GL::FOG_MODE, $fogMode)
  GL.Fog(GL::FOG_COLOR, $fogColor)
  #GL.Fog(GL::FOG_DENSITY, 0.35)
  GL.Fog(GL::FOG_DENSITY, 0.05)
  GL.Hint(GL::FOG_HINT, GL::DONT_CARE)
   
   
end

idle = proc {
  GLUT.PostRedisplay()
}

visible = proc{|visible|
  if visible == GLUT::VISIBLE
    GLUT.IdleFunc(idle)
  else
    GLUT.IdleFunc(nil)
  end
}

keyboard = proc {|key, x, y|
   case (key)
   when 27:
    puts "Programmez!, abonnez vous :)"
    exit(0)
  else
    printf("%c\n", key)
   end
}

mouse = proc {|button, state, x, y|
  case(state)
    when 1: # si bouton enfonc
    case (button)
      when GLUT::LEFT_BUTTON:
      printf("X = %d, Y = %d\n", x,  y)
    end
  end
}

reshape = proc { |width, height|
	GL.Viewport(0, 0, width, height)
  GL.MatrixMode(GL::PROJECTION)
  GL.LoadIdentity()
  GL.Frustum(-1.0, 1.0, -1.0, 1.0, 10.0, 50.0)
  GL.MatrixMode(GL::MODELVIEW)
}


selectFog = proc {|mode|
    case (mode)
        when GL::LINEAR:
          GL.Fog(GL::FOG_START, 1.0)
          GL.Fog(GL::FOG_END, 5.0)
          GL.Fog(GL::FOG_MODE, mode)
          GLUT.PostRedisplay()
         when  GL::EXP2, GL::EXP:
          GL.Fog(GL::FOG_MODE, mode)
          GLUT.PostRedisplay()
        when 0
          exit(0)
    end
}

GLUT.Init()
GLUT.InitDisplayMode(GLUT::RGB | GLUT::DEPTH | GLUT::DOUBLE)
GLUT.InitWindowSize(WIDTH, HEIGHT)
GLUT.InitWindowPosition(X_INIT, Y_INIT)
GLUT.CreateWindow()
init()
GLUT.DisplayFunc(display)
GLUT.KeyboardFunc(keyboard)
GLUT.MouseFunc(mouse)
GLUT.ReshapeFunc(reshape)
GLUT.VisibilityFunc(visible)
# Cration du menu pour la gestion du brouilalrd
GLUT.CreateMenu(selectFog);
GLUT.AddMenuEntry("Fog EXP", GL::EXP);
GLUT.AddMenuEntry("Fog EXP2", GL::EXP2);
GLUT.AddMenuEntry("Fog LINEAR", GL::LINEAR);
GLUT.AddMenuEntry("Quit", 0);
GLUT.AttachMenu(GLUT::RIGHT_BUTTON);
GLUT.MainLoop()

