package fred;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;

import com.lowagie.text.Document;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;


import java.lang.Math;

import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;


class XYSeriesCreator {
    public static XYSeries createXYSeries(String name)
    {
        int year = 2000;
        XYSeries xys = new XYSeries(name);
        for(int i=year; i<year+11; i++)
        {
            xys.add(new Integer(i), new Double(Math.random()*100.0));
        }
        return xys;
    }
}

class XYPlotCreator {
	public static JFreeChart getXYPlotChart() {
        XYSeries xys1 = XYSeriesCreator.createXYSeries("XY Series 1");
        XYSeries xys2 = XYSeriesCreator.createXYSeries("XY Series 2");
        XYSeriesCollection data = new XYSeriesCollection();
        data.addSeries(xys1);
        data.addSeries(xys2);
        JFreeChart chart = ChartFactory.createXYLineChart(
            "Demo XY Series",
            "Annes", 
            "Bnfices", 
            data,
            PlotOrientation.VERTICAL,
            true,
            true,
            false
        );
        return chart;
    }
}


public class JFreeChartInPDF {
	
public static void main(String[] args) {
	PdfWriter pdfwriter;
	Document document = new Document(PageSize.A4);
	try {		
		pdfwriter = PdfWriter.getInstance(document,
				new FileOutputStream("JFreeChartInPDF.pdf"));
		document.addAuthor("Fred");
		document.addCreator("Programmez!");
		document.addSubject("Magazine Programmez!");
		document.addTitle("Prsentation");
		document.open();
		
		Paragraph paragraph = new Paragraph(
				"Programmez!",
				FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
						Font.BOLDITALIC, new Color(0, 0, 0)));
		document.add(paragraph);
				
		Rectangle rect = new Rectangle(300, 300);
		PdfContentByte cb = pdfwriter.getDirectContent();
		PdfTemplate tp = cb.createTemplate(rect.width(), rect.height());
		Graphics2D g2d;	
		g2d = tp.createGraphics(rect.width(), rect.height(),
				new DefaultFontMapper());
		Rectangle2D rect2d = new Rectangle2D.Float(
				0, 0, rect.width(), rect.height());
		JFreeChart chart = XYPlotCreator.getXYPlotChart();
		chart.draw(g2d, rect2d);
		g2d.dispose();
		Image image = Image.getInstance(tp);
		document.add(image);
		
		/*
		       PdfContentByte cb = writer.getDirectContent();
      PdfTemplate tp = cb.createTemplate(width, height);
      Graphics2D g2d = tp.createGraphics(width, height, new DefaultFontMapper());
      Rectangle2D r2d = new Rectangle2D.Double(0, 0, width, height);
      chart.draw(g2d, r2d);
      g2d.dispose();
      cb.addTemplate(tp, 0, 0
		 */
		/*
		paragraph = new Paragraph(
				"Visitez notre site et notre forum :-)",
				FontFactory.getFont(FontFactory.TIMES_ITALIC, 24,
						Font.BOLDITALIC, new Color(0, 0, 0)));
		paragraph.setSpacingBefore(260f);
		document.add(paragraph);
		*/
		System.out.println("Gnration JFreeChart PDF termine");
	}
	catch (Exception e) {
		e.printStackTrace();
	}
	document.close();
	}
}
