
public class ElementOneDescriptor extends DataFrameDescriptor{

    public ElementOneDescriptor(String path) {
        super(path);
    }
    @Override
    public void buildSchema(PairList<String, DataType> schema) {
        schema.add("elementOne_id", DataTypes.LongType);
        schema.add("name", DataTypes.StringType);
        schema.add("value", DataTypes.StringType);
    }
}

for (ExtractLoadElement element : elements) {
   String inputURI = "s3a://" + (get("bucketName") + "/"  + "csv";
   String outputURI = "s3a://" + (get("bucketName") + "/"  + "parquet";
   String parquetPath = element.getCsvPath() + "parquet/";
   DataFrameDescriptor descriptor = null;
   switch (element.getType()) {
       case "elementOne":
           descriptor = new ElementOneDescriptor(inputURI).setMultiHeader(true);
           break;
       case /*
       		...*/	       	
           break;
 }
   descriptor.getDF(sqlContext()).coalesce(Integer.parseInt(get(PARAM_NB_PARTITIONS))).write()
                                .format("parquet").mode(SaveMode.Overwrite).save(outputURI);
}

// Lecture du fichier parquet, et sauvegarde dans une table temporaire stockée en mémoire
sqlContext().read().format("parquet").load(get(PARAM_GENERIC_TABLE_PATH)).registerTempTable("site_table");
// Stockage des résultats dans une DataFrame
DataFrame results = sqlContext()
                      .sql("SELECT " +
                          "store_id ," +
                          // Utilisation d'une UDF
                          "getOccupationalCategoryId(occupational_category_name) AS OC_id ," +
                          // Utilisation d'une méthode de la classe SparkETL
                          get(PARAM_LOAD_PRIORITY) + " AS load_priority " +
                          "FROM  site_table "+
                          "WHERE element_type = 'pro' ");
// Stockage en JSON
results.write().format("json").mode(SaveMode.Overwrite).save(get(PARAM_OUTPUT_PATH));

private UDFHelper resolveDimensionsFromDWH(DatawarehouseDAO dwhDao) throws SQLException {
	// Récupération dans des map, des clés et valeur recherchées dans les référentiels
	final Map<Integer, Integer>                 occCat        = dwhDao.getOCId();
	
	// Diffusion des variables sur tous les noeuds du cluster via le java spark context (jsc)
	final Broadcast<Map<Integer, Integer>>                  bvarOC    = jsc().broadcast(occCat);

UDFHelper udfDict = new UDFHelper(sqlContext());
    udfDictionary.registerLookup("getOCId", bvarOC, DataTypes.IntegerType, 1);
    
public <K, V> void registerLookup(String udfName, Broadcast<Map<K, V>> map, DataType retType, V unknownTag) {
  sqlContext.udf().register(udfName,
    (K key) -> {
      V value = map.value().get(key);
      if (value == null) return unknownTag;
      return value;
    },
    retType);
}