﻿using Microsoft.Synchronization;
using Microsoft.Synchronization.Files;

namespace MasterSlave
{
    class Program
    {
        private string masterpath = "D:\\master";
        private string slavepath = "D:\\slave";

        private void Run()
        {
            FileSyncProvider masterProvider = new FileSyncProvider(masterpath);
            FileSyncProvider slaveProvider = new FileSyncProvider(slavepath);

            SyncOrchestrator orchestrator = new SyncOrchestrator();
            orchestrator.LocalProvider = masterProvider;
            orchestrator.RemoteProvider = slaveProvider;
            orchestrator.Direction = SyncDirectionOrder.UploadAndDownload;
            orchestrator.Synchronize();
        }

        static void Main(string[] args)
        {
            Program p = new Program();
            p.Run();
        }
    }
}

