﻿using System;
using Microsoft.Synchronization;
using Microsoft.Synchronization.Files;

namespace MasterSlavePreview
{
    class Program
    {
        private bool previewmode = true;
        private string masterpath = "D:\\master";
        private string slavepath = "D:\\slave";
        private string mdfile = "filesync.metadata";
        private string tmp = "D:\\temp";
        private string masterCorbeille = "D:\\mastercorbeille";
        private string slaveCorbeille = "D:\\slavecorbeille";

        private void Run()
        {
            // pas de filtre
            FileSyncProvider masterProvider = new FileSyncProvider(masterpath, null,
                FileSyncOptions.None,
                masterpath, mdfile, tmp,
                masterCorbeille);
            masterProvider.PreviewMode = previewmode;

            masterProvider.AppliedChange += new EventHandler<AppliedChangeEventArgs>(OnMasterAppliedChange);
            masterProvider.ApplyingChange += new EventHandler<ApplyingChangeEventArgs>(OnMasterApplyingChange);
            masterProvider.SkippedChange += new EventHandler<SkippedChangeEventArgs>(OnMasterSkippedChange);

            FileSyncProvider slaveProvider = new FileSyncProvider(slavepath, null,
                FileSyncOptions.None,
                slavepath, mdfile, tmp,
                slaveCorbeille);
            slaveProvider.PreviewMode = previewmode;

            slaveProvider.AppliedChange += new EventHandler<AppliedChangeEventArgs>(OnSlaveAppliedChange);
            slaveProvider.ApplyingChange += new EventHandler<ApplyingChangeEventArgs>(OnSlaveApplyingChange);
            slaveProvider.SkippedChange += new EventHandler<SkippedChangeEventArgs>(OnSlaveSkippedChange);

            SyncOrchestrator orchestrator = new SyncOrchestrator();
            orchestrator.LocalProvider = masterProvider;
            orchestrator.RemoteProvider = slaveProvider;
            orchestrator.Direction = SyncDirectionOrder.UploadAndDownload;
            orchestrator.Synchronize();
        }

        private void OnMasterAppliedChange(Object sender, AppliedChangeEventArgs evt)
        {
            Console.WriteLine("Evenement OnMasterAppliedChange");

            switch (evt.ChangeType)
            {
                case ChangeType.Create:
                    Console.WriteLine("Applied CREATE " + evt.NewFilePath);
                    break;
                case ChangeType.Delete:
                    Console.WriteLine("Applied DELETE " + evt.OldFilePath);
                    break;
                case ChangeType.Update:
                    Console.WriteLine("Applied OVERWRITE " + evt.OldFilePath);
                    break;
                case ChangeType.Rename:
                    Console.WriteLine("Applied RENAME " + evt.OldFilePath
                        + " -> " + evt.NewFilePath);
                    break;
                default:
                    break;
            }
            Console.WriteLine();
        }

        private void OnMasterApplyingChange(Object sender, ApplyingChangeEventArgs evt)
        {
            Console.WriteLine("Evenement OnMasterApplyingChange");

            if (evt.NewFileData.Name.Equals("programmez.txt"))
            {
                evt.SkipChange = true;
                return;
            }

            switch (evt.ChangeType)
            {
                case ChangeType.Create:
                    Console.WriteLine("Applying CREATE " + evt.NewFileData.Name);
                    break;
                case ChangeType.Delete:
                    Console.WriteLine("Applying DELETE " + evt.CurrentFileData.Name);
                    break;
                case ChangeType.Update:
                    Console.WriteLine("Applying OVERWRITE " + evt.CurrentFileData.Name);
                    break;
                case ChangeType.Rename:
                    Console.WriteLine("Applied RENAME " + evt.CurrentFileData.Name
                        + " -> " + evt.NewFileData.Name);
                    break;
                default:
                    break;
            }
            Console.WriteLine();
        }

        private void OnMasterSkippedChange(Object sender, SkippedChangeEventArgs evt)
        {
            Console.WriteLine("Skipped " + evt.NewFilePath);
            Console.WriteLine("Reason: " + evt.SkipReason.ToString());
        }

        private void OnSlaveAppliedChange(Object sender, AppliedChangeEventArgs evt)
        {
            Console.WriteLine("Evenement OnSlaveAppliedChange");
            switch (evt.ChangeType)
            {
                case ChangeType.Create:
                    Console.WriteLine("Applied CREATE " + evt.NewFilePath);
                    break;
                case ChangeType.Delete:
                    Console.WriteLine("Applied DELETE " + evt.OldFilePath);
                    break;
                case ChangeType.Update:
                    Console.WriteLine("Applied OVERWRITE " + evt.OldFilePath);
                    break;
                case ChangeType.Rename:
                    Console.WriteLine("Applied RENAME " + evt.OldFilePath
                        + " -> " + evt.NewFilePath);
                    break;
                default:
                    break;
            }
            Console.WriteLine();
        }

        private void OnSlaveApplyingChange(Object sender, ApplyingChangeEventArgs evt)
        {
            Console.WriteLine("Evenement OnSlaveApplyingChange");

            if (evt.NewFileData.Name.Equals("programmez.txt"))
            {
                evt.SkipChange = true;
                return;
            }

            switch (evt.ChangeType)
            {
                case ChangeType.Create:
                    Console.WriteLine("Applying CREATE " + evt.NewFileData.Name);
                    break;
                case ChangeType.Delete:
                    Console.WriteLine("Applying DELETE " + evt.CurrentFileData.Name);
                    break;
                case ChangeType.Update:
                    Console.WriteLine("Applying OVERWRITE " + evt.CurrentFileData.Name);
                    break;
                case ChangeType.Rename:
                    Console.WriteLine("Applied RENAME " + evt.CurrentFileData.Name
                        + " -> " + evt.NewFileData.Name);
                    break;
                default:
                    break;
            }
            Console.WriteLine();
        }

        private void OnSlaveSkippedChange(Object sender, SkippedChangeEventArgs evt)
        {
            Console.WriteLine("Skipped " + evt.NewFilePath);
            Console.WriteLine("Reason: " + evt.SkipReason.ToString());
        }

        static void Main(string[] args)
        {
            Program p = new Program();
            p.Run();
        }
    }
}
