# Chaplin & Brunch TodoMVC Example

> Chaplin is an architecture for JavaScript applications using the Backbone.js library. Chaplin addresses Backbone’s limitations by providing a lightweight and flexible structure that features well-proven design patterns and best practices.

In this case, Backbone is replaced with [Exoskeleton](http://exosjs.com),
faster and leaner Backbone without dependencies on jQuery and underscore.

> _[Chaplin - chaplinjs.org](http://chaplinjs.org)_


## Learning Chaplin

The [Chaplin website](http://chaplinjs.org) is a great resource for getting started.

Here are some links you may find helpful:

* [Getting Started](https://github.com/chaplinjs/chaplin/blob/master/docs/getting_started.md)
* [Documentation](https://github.com/chaplinjs/chaplin/tree/master/docs)
* [API Reference](https://github.com/chaplinjs/chaplin/tree/master/docs#api-docs)
* [Annotated Source Code](http://chaplinjs.org/annotated/chaplin.html)
* [Applications built with Chaplin](https://github.com/chaplinjs/chaplin/wiki/Projects-and-companies-using-Chaplin)
* [Cookbook](https://github.com/chaplinjs/chaplin/wiki/Cookbook)
* [Chaplin on GitHub](https://github.com/chaplinjs)

Articles and guides from the community:

* [JavaScript MVC frameworks: A Comparison of Marionette and Chaplin](http://9elements.com/io/index.php/comparison-of-marionette-and-chaplin/)

Get help from other Chaplin users:

* [Chaplin on StackOverflow](http://stackoverflow.com/questions/tagged/chaplinjs)
* [Chaplin on Twitter](http://twitter.com/chaplinjs)

_If you have other helpful links to share, or find any of the links above no longer work, please [let us know](https://github.com/tastejs/todomvc/issues)._


## Running

If you haven't already installed [Brunch](http://brunch.io), run:

	npm install -g brunch

Once you have Brunch, install this application's dependencies:

	# from examples/chaplin-brunch
	npm install & bower install

To build the app, run:

	# from examples/chaplin-brunch
	brunch build

To watch for changes and re-compile:

	# from examples/chaplin-brunch
	brunch watch

Open `public/index.html` in your browser to see it in action!


## Credit

This TodoMVC application was created by [@paulmillr](http://paulmillr.com).
