# SAPUI5/OpenUI5 • [TodoMVC](http://todomvc.com)

> The UI development toolkit for HTML5 (SAPUI5) is a platform for developing rich user interfaces for modern Web business applications.
> SAPUI5 has the following advantages:
> - SAPUI5 is an enterprise-ready web toolkit with powerful development concepts:
>   - Built-in extensibility concepts at code and application level
>   - Data binding types and Model-View-Controller (MVC)
>   - Full translation support
>   - Keyboard interaction support and accessiblity features
>   - And many more....
> - Apps developed with SAPUI5 present one consistent user experience.
> - SAPUI5 comes with many feature-rich UI controls for handling complex UI patterns and predefined layouts for typical use cases.
> - Apps built with SAPUI5 are responsive across browsers and devices - they run on smartphones, tablets, and desktops. The UI controls automatically adapt themselves to the capabilities of each device.


## Resources

- [SAPUI5](https://sapui5.netweaver.ondemand.com/sdk/#docs/guide/95d113be50ae40d5b0b562b84d715227.html)
- [OpenUI5](http://openui5.org/): The open source version of SAPUI5
- [SAPUI5 SDK](https://sapui5.netweaver.ondemand.com/sdk)


### Articles

- [What is SAPUI5/OpenUI5](http://scn.sap.com/community/developer-center/front-end/blog/2013/12/11/what-is-openui5-sapui5)

### Support

- [SAPUI5 Developer Center](http://scn.sap.com/community/developer-center/front-end)
- [StackOverflow](http://stackoverflow.com/questions/tagged/sapui5)
- [OpenUI5 on Twitter](https://twitter.com/OpenUI5)

*Let us [know](https://github.com/tastejs/todomvc/issues) if you discover anything worth sharing.*


## Implementation

[A detailed article on the SAPUI5 TodoMVC implementation](http://scn.sap.com/community/developer-center/front-end/blog/2013/03/19/how-to-build-testable-sapui5-applications)


## Credit

Created by [Harald Schubert](http://scn.sap.com/people/harald.schubert) [@haraldschubert](https://twitter.com/haraldschubert)
