// Generated by CoffeeScript 1.6.3
(function() {
  var App, AppController, Todo, TodoController, app, router, _ref, _ref1,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Todo = (function(_super) {
    __extends(Todo, _super);

    function Todo() {
      _ref = Todo.__super__.constructor.apply(this, arguments);
      return _ref;
    }

    Todo.belongsTo('app', {
      inverseOf: 'all',
      as: function() {
        return App;
      }
    });

    Todo.property('title', {
      serialize: true
    });

    Todo.property('completed', {
      serialize: true
    });

    Todo.property('incomplete', {
      get: function() {
        return !this.completed;
      }
    });

    Todo.property('edit');

    Todo.prototype.remove = function() {
      return this.app.all["delete"](this);
    };

    return Todo;

  })(Serenade.Model);

  App = (function(_super) {
    __extends(App, _super);

    function App() {
      _ref1 = App.__super__.constructor.apply(this, arguments);
      return _ref1;
    }

    App.hasMany('all', {
      inverseOf: 'app',
      serialize: true,
      as: function() {
        return Todo;
      }
    });

    App.selection('active', {
      from: 'all',
      filter: 'incomplete'
    });

    App.selection('completed', {
      from: 'all',
      filter: 'completed'
    });

    App.property('label', {
      get: function() {
        if (this.activeCount === 1) {
          return 'item left';
        } else {
          return 'items left';
        }
      }
    });

    App.property('allCompleted', {
      get: function() {
        return this.activeCount === 0;
      },
      set: function(value) {
        var todo, _i, _len, _ref2, _results;
        _ref2 = this.all;
        _results = [];
        for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
          todo = _ref2[_i];
          _results.push(todo.completed = value);
        }
        return _results;
      }
    });

    App.property('newTitle');

    App.property('filter', {
      value: 'all'
    });

    App.property('filtered', {
      get: function() {
        return this[this.filter];
      }
    });

    App.property('filterAll', {
      get: function() {
        return this.filter === 'all';
      }
    });

    App.property('filterActive', {
      get: function() {
        return this.filter === 'active';
      }
    });

    App.property('filterCompleted', {
      get: function() {
        return this.filter === 'completed';
      }
    });

    return App;

  })(Serenade.Model);

  AppController = (function() {
    function AppController(app) {
      this.app = app;
    }

    AppController.prototype.newTodo = function() {
      var title;
      title = this.app.newTitle.trim();
      if (title) {
        this.app.all.push({
          title: title
        });
      }
      return this.app.newTitle = '';
    };

    AppController.prototype.clearCompleted = function() {
      return this.app.all = this.app.active;
    };

    return AppController;

  })();

  TodoController = (function() {
    function TodoController(todo) {
      this.todo = todo;
    }

    TodoController.prototype.removeTodo = function() {
      return this.todo.remove();
    };

    TodoController.prototype.edit = function() {
      this.todo.edit = true;
      return this.field.select();
    };

    TodoController.prototype.edited = function() {
      if (this.todo.title.trim()) {
        this.todo.title = this.todo.title.trim();
        if (this.todo.edit) {
          this.todo.edit = false;
        }
      } else {
        this.todo.remove();
      }
      return this.todo.app.changed.trigger();
    };

    TodoController.prototype.loadField = function(field) {
      this.field = field;
    };

    return TodoController;

  })();

  app = new App(JSON.parse(localStorage.getItem('todos-serenade')));

  app.changed.bind(function() {
    return localStorage.setItem('todos-serenade', app);
  });

  router = Router({
    '/': function() {
      return app.filter = 'all';
    },
    '/active': function() {
      return app.filter = 'active';
    },
    '/completed': function() {
      return app.filter = 'completed';
    }
  });

  router.init();

  Serenade.view('app', document.getElementById('app').innerHTML);

  Serenade.view('todo', document.getElementById('todo').innerHTML);

  Serenade.controller('app', AppController);

  Serenade.controller('todo', TodoController);

  document.body.insertBefore(Serenade.render('app', app), document.body.children[0]);

}).call(this);
