# SocketStream TodoMVC Example

> SocketStream is a fast, modular Node.js web framework dedicated to building realtime single-page apps.

> _[SocketStream - socketstream.org](http://socketstream.org)_


## Learning SocketStream

The [SocketStream website](http://socketstream.org) is a great resource for getting started.

Here are some links you may find helpful:

* [Tour](http://www.socketstream.org/tour)
* [SocketStream on GitHub](https://github.com/socketstream)

Articles and guides from the community:

* [Video - Owen Barnes introduces SocketStream](http://www.infoq.com/presentations/SocketStream)

Get help from other SocketStream users:

* [SocketStream on StackOverflow](http://stackoverflow.com/questions/tagged/socketstream)
* [SocketStream on Twitter](http://twitter.com/socketstream)

_If you have other helpful links to share, or find any of the links above no longer work, please [let us know](https://github.com/tastejs/todomvc/issues)._


## Running

Running this app requires [Node.js](http://nodejs.org).

	# from examples/socketstream
	npm install
	npm start

Open http://localhost:3000 in two side-by-side browser windows, add a todo, and see the magic.


## Internal

How to publish to our Heroku remote:

- `git remote add heroku-todomvc-socketstream master` *(first time only)*
- `git subtree push --prefix examples/socketstream heroku-todomvc-socketstream master`
