// Generated by CoffeeScript 1.10.0
(function() {
  var TodoApp,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  TodoApp = (function(superClass) {
    var ENTER_KEY;

    extend(TodoApp, superClass);

    ENTER_KEY = 13;

    TodoApp.prototype.elements = {
      '#new-todo': 'newTodoInput',
      '#toggle-all': 'toggleAllElem',
      '#main': 'main',
      '#todo-list': 'todos',
      '#footer': 'footer',
      '#todo-count': 'count',
      '#filters a': 'filters',
      '#clear-completed': 'clearCompleted'
    };

    TodoApp.prototype.events = {
      'keyup #new-todo': 'new',
      'click #toggle-all': 'toggleAll',
      'click #clear-completed': 'clearCompletedItem'
    };

    function TodoApp() {
      this.renderFooter = bind(this.renderFooter, this);
      this.toggleElems = bind(this.toggleElems, this);
      this.addAll = bind(this.addAll, this);
      this.addNew = bind(this.addNew, this);
      TodoApp.__super__.constructor.apply(this, arguments);
      Todo.bind('create', this.addNew);
      Todo.bind('refresh change', this.addAll);
      Todo.bind('refresh change', this.toggleElems);
      Todo.bind('refresh change', this.renderFooter);
      Todo.fetch();
      this.routes({
        '/:filter': function(param) {
          this.filter = param.filter;

          /*
          				TODO: Need to figure out why the route doesn't trigger `change` event
           */
          Todo.trigger('refresh');
          return this.filters.removeClass('selected').filter("[href='#/" + this.filter + "']").addClass('selected');
        }
      });
    }

    TodoApp.prototype["new"] = function(e) {
      var val;
      val = $.trim(this.newTodoInput.val());
      if (e.which === ENTER_KEY && val) {
        Todo.create({
          title: val
        });
        return this.newTodoInput.val('');
      }
    };

    TodoApp.prototype.getByFilter = function() {
      switch (this.filter) {
        case 'active':
          return Todo.active();
        case 'completed':
          return Todo.completed();
        default:
          return Todo.all();
      }
    };

    TodoApp.prototype.addNew = function(todo) {
      var view;
      view = new Todos({
        todo: todo
      });
      return this.todos.append(view.render().el);
    };

    TodoApp.prototype.addAll = function() {
      var i, len, ref, results, todo;
      this.todos.empty();
      ref = this.getByFilter();
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        todo = ref[i];
        results.push(this.addNew(todo));
      }
      return results;
    };

    TodoApp.prototype.toggleAll = function(e) {
      var checked;
      checked = e.target.checked;
      return Todo.each(function(todo) {

        /*
        			TODO: Model updateAttribute sometimes won't stick:
        				https://github.com/maccman/spine/issues/219
         */
        todo.updateAttribute('completed', checked);
        return todo.trigger('update', todo);
      });
    };

    TodoApp.prototype.clearCompletedItem = function() {
      return Todo.destroyCompleted();
    };

    TodoApp.prototype.toggleElems = function() {
      var completed, total;
      completed = Todo.completed().length;
      total = Todo.count();
      this.main.toggle(total !== 0);
      this.footer.toggle(total !== 0);
      this.toggleAllElem.prop('checked', completed === total);
      return this.clearCompleted.toggle(completed !== 0);
    };

    TodoApp.prototype.renderFooter = function() {
      var active, completed, text;
      text = function(count) {
        if (count === 1) {
          return 'item';
        } else {
          return 'items';
        }
      };
      active = Todo.active().length;
      completed = Todo.completed().length;
      return this.count.html("<strong>" + active + "</strong> " + (text(active)) + " left");
    };

    return TodoApp;

  })(Spine.Controller);

  $(function() {
    new TodoApp({
      el: $('#todoapp')
    });
    return Spine.Route.setup();
  });

}).call(this);
