// Generated by CoffeeScript 1.9.1
(function() {
  var bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  window.Todos = (function(superClass) {
    var ENTER_KEY, ESCAPE_KEY, TPL;

    extend(Todos, superClass);

    ENTER_KEY = 13;

    ESCAPE_KEY = 27;

    TPL = Handlebars.compile($('#todo-template').html());

    Todos.prototype.elements = {
      '.edit': 'editElem'
    };

    Todos.prototype.events = {
      'click    .destroy': 'remove',
      'click    .toggle': 'toggleStatus',
      'dblclick label': 'edit',
      'keydown  .edit': 'revertEditOnEscape',
      'keyup    .edit': 'finishEditOnEnter',
      'blur     .edit': 'finishEdit'
    };

    function Todos() {
      this.render = bind(this.render, this);
      Todos.__super__.constructor.apply(this, arguments);
      this.todo.bind('update', this.render);
      this.todo.bind('destroy', this.release);
    }

    Todos.prototype.render = function() {
      this.replace(TPL(this.todo));
      return this;
    };

    Todos.prototype.remove = function() {
      return this.todo.destroy();
    };

    Todos.prototype.toggleStatus = function() {
      return this.todo.updateAttribute('completed', !this.todo.completed);
    };

    Todos.prototype.edit = function() {
      this.el.addClass('editing');
      return this.editElem.val(this.editElem.val()).focus();
    };

    Todos.prototype.finishEdit = function() {
      var val;
      this.el.removeClass('editing');
      val = $.trim(this.editElem.val());
      if (val) {
        return this.todo.updateAttribute('title', val);
      } else {
        return this.remove();
      }
    };

    Todos.prototype.finishEditOnEnter = function(e) {
      if (e.which === ENTER_KEY) {
        return this.finishEdit();
      }
    };

    Todos.prototype.revertEdit = function() {
      this.el.removeClass('editing');
      return this.editElem.val(this.todo.title);
    };

    Todos.prototype.revertEditOnEscape = function(e) {
      if (e.which === ESCAPE_KEY) {
        return this.revertEdit();
      }
    };

    return Todos;

  })(Spine.Controller);

}).call(this);
