// Generated by CoffeeScript 1.8.0
(function() {
  var $, Path, Route, Spine, escapeRegExp, hashStrip, namedParam, splatParam,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __slice = [].slice;

  Spine = this.Spine || require('spine');

  $ = Spine.$;

  hashStrip = /^#*/;

  namedParam = /:([\w\d]+)/g;

  splatParam = /\*([\w\d]+)/g;

  escapeRegExp = /[-[\]{}()+?.,\\^$|#\s]/g;

  Path = (function(_super) {
    __extends(Path, _super);

    function Path(path, callback) {
      var match;
      this.path = path;
      this.callback = callback;
      this.names = [];
      if (typeof path === 'string') {
        namedParam.lastIndex = 0;
        while ((match = namedParam.exec(path)) !== null) {
          this.names.push(match[1]);
        }
        splatParam.lastIndex = 0;
        while ((match = splatParam.exec(path)) !== null) {
          this.names.push(match[1]);
        }
        path = path.replace(escapeRegExp, '\\$&').replace(namedParam, '([^\/]*)').replace(splatParam, '(.*?)');
        this.route = new RegExp("^" + path + "$");
      } else {
        this.route = path;
      }
    }

    Path.prototype.match = function(path, options) {
      var i, match, param, params, _i, _len;
      if (options == null) {
        options = {};
      }
      if (!(match = this.route.exec(path))) {
        return false;
      }
      options.match = match;
      params = match.slice(1);
      if (this.names.length) {
        for (i = _i = 0, _len = params.length; _i < _len; i = ++_i) {
          param = params[i];
          options[this.names[i]] = param;
        }
      }
      Route.trigger('before', this);
      return this.callback.call(null, options) !== false;
    };

    return Path;

  })(Spine.Module);

  Route = (function(_super) {
    var _ref;

    __extends(Route, _super);

    Route.extend(Spine.Events);

    Route.historySupport = ((_ref = window.history) != null ? _ref.pushState : void 0) != null;

    Route.options = {
      trigger: true,
      history: false,
      shim: false,
      replace: false,
      redirect: false
    };

    Route.routers = [];

    Route.setup = function(options) {
      if (options == null) {
        options = {};
      }
      this.options = $.extend({}, this.options, options);
      if (this.options.history) {
        this.history = this.historySupport && this.options.history;
      }
      if (this.options.shim) {
        return;
      }
      if (this.history) {
        $(window).bind('popstate', this.change);
      } else {
        $(window).bind('hashchange', this.change);
      }
      return this.change();
    };

    Route.unbind = function() {
      var unbindResult;
      unbindResult = Spine.Events.unbind.apply(this, arguments);
      if (arguments.length > 0) {
        return unbindResult;
      }
      if (this.options.shim) {
        return;
      }
      if (this.history) {
        return $(window).unbind('popstate', this.change);
      } else {
        return $(window).unbind('hashchange', this.change);
      }
    };

    Route.navigate = function() {
      var args, lastArg, options, path, routes;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      options = {};
      lastArg = args[args.length - 1];
      if (typeof lastArg === 'object') {
        options = args.pop();
      } else if (typeof lastArg === 'boolean') {
        options.trigger = args.pop();
      }
      options = $.extend({}, this.options, options);
      path = args.join('/');
      if (this.path === path) {
        return;
      }
      this.path = path;
      if (options.trigger) {
        this.trigger('navigate', this.path);
        routes = this.matchRoutes(this.path, options);
        if (!routes.length) {
          if (typeof options.redirect === 'function') {
            return options.redirect.apply(this, [this.path, options]);
          } else {
            if (options.redirect === true) {
              this.redirect(this.path);
            }
          }
        }
      }
      if (options.shim) {
        return true;
      } else if (this.history && options.replace) {
        return history.replaceState({}, document.title, this.path);
      } else if (this.history) {
        return history.pushState({}, document.title, this.path);
      } else {
        return window.location.hash = this.path;
      }
    };

    Route.create = function() {
      var router;
      router = new this;
      this.routers.push(router);
      return router;
    };

    Route.add = function(path, callback) {
      return this.router.add(path, callback);
    };

    Route.prototype.add = function(path, callback) {
      var key, value, _results;
      if (typeof path === 'object' && !(path instanceof RegExp)) {
        _results = [];
        for (key in path) {
          value = path[key];
          _results.push(this.add(key, value));
        }
        return _results;
      } else {
        return this.routes.push(new Path(path, callback));
      }
    };

    Route.prototype.destroy = function() {
      var r;
      this.routes.length = 0;
      return this.constructor.routers = (function() {
        var _i, _len, _ref1, _results;
        _ref1 = this.constructor.routers;
        _results = [];
        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
          r = _ref1[_i];
          if (r !== this) {
            _results.push(r);
          }
        }
        return _results;
      }).call(this);
    };

    Route.getPath = function() {
      var path;
      if (this.history) {
        path = window.location.pathname;
        if (path.substr(0, 1) !== '/') {
          path = '/' + path;
        }
      } else {
        path = window.location.hash;
        path = path.replace(hashStrip, '');
      }
      return path;
    };

    Route.getHost = function() {
      return "" + window.location.protocol + "//" + window.location.host;
    };

    Route.change = function() {
      var path;
      path = Route.getPath();
      if (path === Route.path) {
        return;
      }
      Route.path = path;
      return Route.matchRoutes(Route.path);
    };

    Route.matchRoutes = function(path, options) {
      var match, matches, router, _i, _len, _ref1;
      matches = [];
      _ref1 = this.routers.concat([this.router]);
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        router = _ref1[_i];
        match = router.matchRoute(path, options);
        if (match) {
          matches.push(match);
        }
      }
      if (matches.length) {
        this.trigger('change', matches, path);
      }
      return matches;
    };

    Route.redirect = function(path) {
      return window.location = path;
    };

    function Route() {
      this.routes = [];
    }

    Route.prototype.matchRoute = function(path, options) {
      var route, _i, _len, _ref1;
      _ref1 = this.routes;
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        route = _ref1[_i];
        if (route.match(path, options)) {
          return route;
        }
      }
    };

    Route.prototype.trigger = function() {
      var args, _ref1;
      args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
      args.splice(1, 0, this);
      return (_ref1 = this.constructor).trigger.apply(_ref1, args);
    };

    return Route;

  })(Spine.Module);

  Route.router = new Route;

  Spine.Controller.include({
    route: function(path, callback) {
      if (this.router instanceof Spine.Route) {
        return this.router.add(path, this.proxy(callback));
      } else {
        return Spine.Route.add(path, this.proxy(callback));
      }
    },
    routes: function(routes) {
      var key, value, _results;
      _results = [];
      for (key in routes) {
        value = routes[key];
        _results.push(this.route(key, value));
      }
      return _results;
    },
    navigate: function() {
      return Spine.Route.navigate.apply(Spine.Route, arguments);
    }
  });

  Route.Path = Path;

  Spine.Route = Route;

  if (typeof module !== "undefined" && module !== null) {
    module.exports = Route;
  }

}).call(this);

//# sourceMappingURL=route.js.map
