---
external help file: UniversalDashboard.dll-Help.xml
Module Name: UniversalDashboard.Community
online version:
schema: 2.0.0
---

# New-UDLink

## SYNOPSIS
Creates an HTML link. 

## SYNTAX

```
New-UDLink -Text <String> -Url <String> [-Icon <FontAwesomeIcons>] [-OpenInNewWindow]
 [-FontColor <DashboardColor>] [<CommonParameters>]
```

## DESCRIPTION
Creates an HTML link. 

## EXAMPLES

### Example 1
```
PS C:\> New-UDLink -Text "PowerShell Pro Tools" -Url "https://www.poshtools.com"
```

Creates an HTML link to PoshTools.com

## PARAMETERS

### -FontColor
The font color for this link.

```yaml
Type: DashboardColor
Parameter Sets: (All)
Aliases:

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Icon
A FontAwesome icon to display before the link text.

```yaml
Type: FontAwesomeIcons
Parameter Sets: (All)
Aliases:
Accepted values: None, _500px, address_book, address_book_o, address_card, address_card_o, adjust, adn, align_center, align_justify, align_left, align_right, amazon, ambulance, american_sign_language_interpreting, anchor, android, angellist, angle_double_down, angle_double_left, angle_double_right, angle_double_up, angle_down, angle_left, angle_right, angle_up, apple, archive, area_chart, arrow_circle_down, arrow_circle_left, arrow_circle_o_down, arrow_circle_o_left, arrow_circle_o_right, arrow_circle_o_up, arrow_circle_right, arrow_circle_up, arrow_down, arrow_left, arrow_right, arrow_up, arrows, arrows_alt, arrows_h, arrows_v, asl_interpreting, assistive_listening_systems, asterisk, at, audio_description, automobile, backward, balance_scale, ban, bandcamp, bank, bar_chart, bar_chart_o, barcode, bars, bath, bathtub, battery, battery_0, battery_1, battery_2, battery_3, battery_4, battery_empty, battery_full, battery_half, battery_quarter, battery_three_quarters, bed, beer, behance, behance_square, bell, bell_o, bell_slash, bell_slash_o, bicycle, binoculars, birthday_cake, bitbucket, bitbucket_square, bitcoin, black_tie, blind, bluetooth, bluetooth_b, bold, bolt, bomb, book, bookmark, bookmark_o, braille, briefcase, btc, bug, building, building_o, bullhorn, bullseye, bus, buysellads, cab, calculator, calendar, calendar_check_o, calendar_minus_o, calendar_o, calendar_plus_o, calendar_times_o, camera, camera_retro, car, caret_down, caret_left, caret_right, caret_square_o_down, caret_square_o_left, caret_square_o_right, caret_square_o_up, caret_up, cart_arrow_down, cart_plus, cc, cc_amex, cc_diners_club, cc_discover, cc_jcb, cc_mastercard, cc_paypal, cc_stripe, cc_visa, certificate, chain, chain_broken, check, check_circle, check_circle_o, check_square, check_square_o, chevron_circle_down, chevron_circle_left, chevron_circle_right, chevron_circle_up, chevron_down, chevron_left, chevron_right, chevron_up, child, chrome, circle, circle_o, circle_o_notch, circle_thin, clipboard, clock_o, clone, close, cloud, cloud_download, cloud_upload, cny, code, code_fork, codepen, codiepie, coffee, cog, cogs, columns, comment, comment_o, commenting, commenting_o, comments, comments_o, compass, compress, connectdevelop, contao, copy, copyright, creative_commons, credit_card, credit_card_alt, crop, crosshairs, css3, cube, cubes, cut, cutlery, dashboard, dashcube, database, deaf, deafness, dedent, delicious, desktop, deviantart, diamond, digg, dollar, dot_circle_o, download, dribbble, drivers_license, drivers_license_o, dropbox, drupal, edge, edit, eercast, eject, ellipsis_h, ellipsis_v, empire, envelope, envelope_o, envelope_open, envelope_open_o, envelope_square, envira, eraser, etsy, eur, euro, exchange, exclamation, exclamation_circle, exclamation_triangle, expand, expeditedssl, external_link, external_link_square, eye, eye_slash, eyedropper, fa, facebook, facebook_f, facebook_official, facebook_square, fast_backward, fast_forward, fax, feed, female, fighter_jet, file, file_archive_o, file_audio_o, file_code_o, file_excel_o, file_image_o, file_movie_o, file_o, file_pdf_o, file_photo_o, file_picture_o, file_powerpoint_o, file_sound_o, file_text, file_text_o, file_video_o, file_word_o, file_zip_o, files_o, film, filter, fire, fire_extinguisher, firefox, first_order, flag, flag_checkered, flag_o, flash, flask, flickr, floppy_o, folder, folder_o, folder_open, folder_open_o, font, font_awesome, fonticons, fort_awesome, forumbee, forward, foursquare, free_code_camp, frown_o, futbol_o, gamepad, gavel, gbp, ge, gear, gears, genderless, get_pocket, gg, gg_circle, gift, git, git_square, github, github_alt, github_square, gitlab, gittip, glass, glide, glide_g, globe, google, google_plus, google_plus_circle, google_plus_official, google_plus_square, google_wallet, graduation_cap, gratipay, grav, group, h_square, hacker_news, hand_grab_o, hand_lizard_o, hand_o_down, hand_o_left, hand_o_right, hand_o_up, hand_paper_o, hand_peace_o, hand_pointer_o, hand_rock_o, hand_scissors_o, hand_spock_o, hand_stop_o, handshake_o, hard_of_hearing, hashtag, hdd_o, header, headphones, heart, heart_o, heartbeat, history, home, hospital_o, hotel, hourglass, hourglass_1, hourglass_2, hourglass_3, hourglass_end, hourglass_half, hourglass_o, hourglass_start, houzz, html5, i_cursor, id_badge, id_card, id_card_o, ils, image, imdb, inbox, indent, industry, info, info_circle, inr, instagram, institution, internet_explorer, intersex, ioxhost, italic, joomla, jpy, jsfiddle, key, keyboard_o, krw, language, laptop, lastfm, lastfm_square, leaf, leanpub, legal, lemon_o, level_down, level_up, life_bouy, life_buoy, life_ring, life_saver, lightbulb_o, line_chart, link, linkedin, linkedin_square, linode, linux, list, list_alt, list_ol, list_ul, location_arrow, _lock, long_arrow_down, long_arrow_left, long_arrow_right, long_arrow_up, low_vision, magic, magnet, mail_forward, mail_reply, mail_reply_all, male, map, map_marker, map_o, map_pin, map_signs, mars, mars_double, mars_stroke, mars_stroke_h, mars_stroke_v, maxcdn, meanpath, medium, medkit, meetup, meh_o, mercury, microchip, microphone, microphone_slash, minus, minus_circle, minus_square, minus_square_o, mixcloud, mobile, mobile_phone, modx, money, moon_o, mortar_board, motorcycle, mouse_pointer, music, navicon, neuter, newspaper_o, object_group, object_ungroup, odnoklassniki, odnoklassniki_square, opencart, openid, opera, optin_monster, outdent, pagelines, paint_brush, paper_plane, paper_plane_o, paperclip, paragraph, paste, pause, pause_circle, pause_circle_o, paw, paypal, pencil, pencil_square, pencil_square_o, percent, phone, phone_square, photo, picture_o, pie_chart, pied_piper, pied_piper_alt, pied_piper_pp, pinterest, pinterest_p, pinterest_square, plane, play, play_circle, play_circle_o, plug, plus, plus_circle, plus_square, plus_square_o, podcast, power_off, print, product_hunt, puzzle_piece, qq, qrcode, question, question_circle, question_circle_o, quora, quote_left, quote_right, ra, random, ravelry, rebel, recycle, reddit, reddit_alien, reddit_square, refresh, registered, remove, renren, reorder, repeat, reply, reply_all, resistance, retweet, rmb, road, rocket, rotate_left, rotate_right, rouble, rss, rss_square, rub, ruble, rupee, s15, safari, save, scissors, scribd, search, search_minus, search_plus, sellsy, send, send_o, server, share, share_alt, share_alt_square, share_square, share_square_o, shekel, sheqel, shield, ship, shirtsinbulk, shopping_bag, shopping_basket, shopping_cart, shower, sign_in, sign_language, sign_out, signal, signing, simplybuilt, sitemap, skyatlas, skype, slack, sliders, slideshare, smile_o, snapchat, snapchat_ghost, snapchat_square, snowflake_o, soccer_ball_o, sort, sort_alpha_asc, sort_alpha_desc, sort_amount_asc, sort_amount_desc, sort_asc, sort_desc, sort_down, sort_numeric_asc, sort_numeric_desc, sort_up, soundcloud, space_shuttle, spinner, spoon, spotify, square, square_o, stack_exchange, stack_overflow, star, star_half, star_half_empty, star_half_full, star_half_o, star_o, steam, steam_square, step_backward, step_forward, stethoscope, sticky_note, sticky_note_o, stop, stop_circle, stop_circle_o, street_view, strikethrough, stumbleupon, stumbleupon_circle, subscript, subway, suitcase, sun_o, superpowers, superscript, support, table, tablet, tachometer, tag, tags, tasks, taxi, telegram, television, tencent_weibo, terminal, text_height, text_width, th, th_large, th_list, themeisle, thermometer, thermometer_0, thermometer_1, thermometer_2, thermometer_3, thermometer_4, thermometer_empty, thermometer_full, thermometer_half, thermometer_quarter, thermometer_three_quarters, thumb_tack, thumbs_down, thumbs_o_down, thumbs_o_up, thumbs_up, ticket, times, times_circle, times_circle_o, times_rectangle, times_rectangle_o, tint, toggle_down, toggle_left, toggle_off, toggle_on, toggle_right, toggle_up, trademark, train, transgender, transgender_alt, trash, trash_o, tree, trello, tripadvisor, trophy, truck, _try, tty, tumblr, tumblr_square, turkish_lira, tv, twitch, twitter, twitter_square, umbrella, underline, undo, universal_access, university, unlink, unlock, unlock_alt, unsorted, upload, usb, usd, user, user_circle, user_circle_o, user_md, user_o, user_plus, user_secret, user_times, users, vcard, vcard_o, venus, venus_double, venus_mars, viacoin, viadeo, viadeo_square, video_camera, vimeo, vimeo_square, vine, vk, volume_control_phone, volume_down, volume_off, volume_up, warning, wechat, weibo, weixin, whatsapp, wheelchair, wheelchair_alt, wifi, wikipedia_w, window_close, window_close_o, window_maximize, window_minimize, window_restore, windows, won, wordpress, wpbeginner, wpexplorer, wpforms, wrench, xing, xing_square, y_combinator, y_combinator_square, yahoo, yc, yc_square, yelp, yen, yoast, youtube, youtube_play, youtube_square

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -OpenInNewWindow
Opens the link in a new window.

```yaml
Type: SwitchParameter
Parameter Sets: (All)
Aliases:

Required: False
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Text
Text for the link.

```yaml
Type: String
Parameter Sets: (All)
Aliases:

Required: True
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### -Url
Url for the link.

```yaml
Type: String
Parameter Sets: (All)
Aliases:

Required: True
Position: Named
Default value: None
Accept pipeline input: False
Accept wildcard characters: False
```

### CommonParameters
This cmdlet supports the common parameters: -Debug, -ErrorAction, -ErrorVariable, -InformationAction, -InformationVariable, -OutVariable, -OutBuffer, -PipelineVariable, -Verbose, -WarningAction, and -WarningVariable. For more information, see about_CommonParameters (http://go.microsoft.com/fwlink/?LinkID=113216).

## INPUTS

### None

## OUTPUTS

### System.Object

## NOTES

## RELATED LINKS
