#include <iostream>
#include <COMUtils.h> // cf. CD-Rom

// objbase.h est normalement dj inclus par COMUtils.h
#include <objbase.h>
#include <icontact.h>
#include <icontactproperties.h>


int main()
{
	try
	{
		HRESULT hr;
		// COM est initialis ici,
		// *AVANT* la dclaration des pointeurs intelligents
		COMInitializer ci;
		SmartCOMPtr<IContactManager> cm;
		SmartCOMPtr<IContact> me, courant;
		SmartCOMPtr<IContactCollection> cc;
		
		hr = ::CoCreateInstance(CLSID_ContactManager,
                          NULL,
                          CLSCTX_INPROC_SERVER,
                          IID_IContactManager,
                          reinterpret_cast<void**>(&cm));
		COMHelper::TestOk(hr);

		hr = cm->Initialize(L"MyAPP", L"1.0");
		COMHelper::TestOk(hr);

		hr = cm->GetMeContact(&me);
		COMHelper::TestOk(hr);

		// ATTENTION ici MAX_PATH n'est PAS une
		// taille suffisante pour le buffer
		WCHAR buffer[MAX_PATH*2] = {0};
		DWORD size = ARRAYSIZE(buffer); 
		DWORD required;
		hr = me->GetContactID(buffer, size, &required);
		COMHelper::TestOk(hr);
		std::cout << "ID du contact de l'utilisateur" << std::endl;
		std::cout << "Remarquez la presence du path!" << std::endl;
		std::wcout << buffer << std::endl;
		std::cout << "----------------------------------------" << std::endl;
		std::cout << "Enumeration de tous les contacts" << std::endl;
		std::cout << "----------------------------------------" << std::endl;
		
		// Obtenir tous les contacts par le biais
		// d'une instance de IContactCollection
		hr = cm->GetContactCollection(&cc);
		COMHelper::TestOk(hr);
		// numrer
		WCHAR familyname[] = CONTACTPROP_PUB_L1_NAMECOLLECTION
			CONTACTPROP_PUB_L2_NAME L"[1]" CONTACTPROP_PUB_L3_FAMILYNAME;
		WCHAR givenname[] = CONTACTPROP_PUB_L1_NAMECOLLECTION
			CONTACTPROP_PUB_L2_NAME L"[1]" CONTACTPROP_PUB_L3_GIVENNAME;
		while(1)
		{
			hr = cc->Next();
			if(hr == S_FALSE)
				break;

			SmartCOMPtr<IContactProperties> icp;
			hr = cc->GetCurrent(&courant);
			COMHelper::TestOk(hr);
			hr = courant->QueryInterface(IID_IContactProperties, 
				reinterpret_cast<void**>(&icp));
			COMHelper::TestOk(hr);
			
			// Obtenir et afficher le nom de famille du contact
			hr = icp->GetString(familyname, CGD_DEFAULT, buffer,
					ARRAYSIZE(buffer), NULL);
			bool nom = false; // pour affiner l'affichage
			switch(hr & 0x0000FFFF)
			{
				case ERROR_PATH_NOT_FOUND: 
					//std::cout << "L'arborescence XML n'existe pas" << std::endl;
					break;
				case S_FALSE:
					std::cout << "Le contact n'a pas de nom" << std::endl;
					break;
				case ERROR_INSUFFICIENT_BUFFER:
					std::cout << "Le nom du contact ne tient"
						" pas dans le buffer" << std::endl;
					break;
				case S_OK:
					std::wcout << buffer << ", ";
					nom = true;
					break;
				default:
					COMHelper::TestOk(hr);
					break;
			}
			
			// Obtenir et afficher le prnom du contact
			hr = icp->GetString(givenname, CGD_DEFAULT, buffer,
					ARRAYSIZE(buffer), NULL);
			switch(hr & 0x0000FFFF)
			{
				case ERROR_PATH_NOT_FOUND: 
					//std::cout << "L'arborescence XML n'existe pas" << std::endl;
					if(nom)
						std::cout << std::endl;
					break;
				case S_FALSE:
					std::cout << "Le contact n'a pas de prenom" << std::endl;
					break;
				case ERROR_INSUFFICIENT_BUFFER:
					std::cout << "Le prenom du contact ne tient"
						" pas dans le buffer" << std::endl;
					break;
				case S_OK:
					std::wcout << buffer << std::endl;
					break;
				default:
					COMHelper::TestOk(hr);
					break;
			}
		}
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
