// DemoCreateContact.cpp :
#include <iostream>
#include <cstdlib> // pour _wsplitpath

#include <COMUtils.h> // cf. CD-Rom
// objbase.h est normalement dj inclus par COMUtils.h
#include <objbase.h>
#include <icontact.h>
#include <icontactproperties.h>
#include <shlwapi.h>

#include <windef.h>   // pour MAX_PATH
#include <winternl.h> // pour ARRAYSIZE

#define FILENAME L"marie.aubin.contact"

#pragma warning(disable : 4996)

std::wstring GetRepository(const WCHAR* full)
{
	WCHAR bdrive[_MAX_DRIVE];
	WCHAR bdir[_MAX_DIR];
	WCHAR bname[_MAX_FNAME];
	WCHAR bext[_MAX_EXT];
	_wsplitpath(full, bdrive, bdir, bname, bext);

	std::wstring result = bdrive;
	result += bdir;
	return result;
}

int main()
{
	std::cout << "Demo Create Contact" << std::endl;
	try
	{
		HRESULT hr;
		WCHAR buffer[MAX_PATH] = {0};
		DWORD size = ARRAYSIZE(buffer); 
		DWORD required;

		// COM est initialis ici,
		// *AVANT* la dclaration des pointeurs intelligents
		COMInitializer ci; 
		SmartCOMPtr<IContact> me, ct;
		SmartCOMPtr<IContactProperties> cp;
		SmartCOMPtr<IContactManager> cm;
		SmartCOMPtr<IPersistStreamInit> psi;
		SmartCOMPtr<IStream> is;
		std::wstring fullname;

		hr = ::CoCreateInstance(CLSID_ContactManager,
			NULL,
			CLSCTX_INPROC_SERVER,
			IID_IContactManager,
			reinterpret_cast<void**>(&cm));
		COMHelper::TestOk(hr);

		hr = cm->Initialize(L"MyAPP", L"1.0");
		COMHelper::TestOk(hr);

		// Obtenir le repository des contacts
		//  partir du contact de l'utilisateur
		hr = cm->GetMeContact(&me);
		COMHelper::TestOk(hr);
		hr = me->GetPath(buffer, size, &required);
		COMHelper::TestOk(hr);
		fullname = GetRepository(buffer);
		// et maintenant constituer le nom
		// complet du fichier de contact  crer
		fullname += FILENAME;

		// Creer une instance de l'interface IContact
		// pour le nouveau contact.
		// Le contact n'a toutefois encore aucune ralit
		hr = ::CoCreateInstance(CLSID_Contact,
                          NULL,
                          CLSCTX_INPROC_SERVER,
                          IID_IContact,
                          reinterpret_cast<void **>(&ct));
		COMHelper::TestOk(hr);

		// Dfinition du contenu (donnes) du contact 
		// D'abord, obtenir l'instance de IPersistStreamInit
		// aggrge  l'instance du contact
		hr = ct->QueryInterface(IID_IPersistStreamInit,
			reinterpret_cast<void **>(&psi));
		COMHelper::TestOk(hr);
		// Initialiser l'instance de IPersistStreamInit
		// ce qui donne "vie" au contact en crant une
		// arborescence XML minimum
		hr = psi->InitNew();
		COMHelper::TestOk(hr);
		// Ds ce stade, notre contact dtient un ID
		hr = ct->GetContactID(buffer, size, &required);
		COMHelper::TestOk(hr);
		std::wcout << L"ID du contact en cours de creation: "
			<< buffer << std::endl;

		// Obtenir l'interface proprits du contact
		hr = ct->QueryInterface(IID_IContactProperties,
			reinterpret_cast<void **>(&cp));
		COMHelper::TestOk(hr);
		// Pour le fun Rcuprer l'ID du contact, mais
		// cette fois depuis les proprits
		WCHAR propid[] = CONTACTPROP_PUB_L1_CONTACTIDCOLLECTION
			CONTACTPROP_PUB_L2_CONTACTID L"[1]" CONTACTPROP_PUB_L3_VALUE;
		hr = cp->GetString(propid, CGD_DEFAULT, buffer,
					ARRAYSIZE(buffer), &required);
		COMHelper::TestOk(hr);
		std::wcout << buffer << std::endl;

		// Dfinir le nom de famille et le prnom du contact
		// Pour cela, d'abord dclarer un noeud dans l'arborescence XML
		WCHAR nodebuffer[2048];
		hr = cp->CreateArrayNode(CONTACTPROP_PUB_L1_NAMECOLLECTION,
			CGD_DEFAULT,
			TRUE,
			nodebuffer,
			ARRAYSIZE(nodebuffer),
			&required);
		COMHelper::TestOk(hr);
		// Puis dfinition du nom de famille
		WCHAR propname[] = CONTACTPROP_PUB_L1_NAMECOLLECTION
			CONTACTPROP_PUB_L2_NAME L"[1]" CONTACTPROP_PUB_L3_FAMILYNAME;
		hr = cp->SetString(propname, CGD_DEFAULT, L"Aubin");
		COMHelper::TestOk(hr);
		// et dfinition du prnom
		WCHAR propgivenname[] = CONTACTPROP_PUB_L1_NAMECOLLECTION
			CONTACTPROP_PUB_L2_NAME L"[1]" CONTACTPROP_PUB_L3_GIVENNAME;
		hr = cp->SetString(propgivenname, CGD_DEFAULT, L"Marie");
		COMHelper::TestOk(hr);

		// Obtenir une instance de IStream,  partir du nom de fichier
		hr = ::SHCreateStreamOnFileEx(fullname.c_str(), STGM_CREATE|STGM_READWRITE,
			FILE_ATTRIBUTE_NORMAL, FALSE, NULL, &is);
		COMHelper::TestOk(hr);

		// et enfin SAUVEGARDE effective
		hr = psi->Save(&(*is), TRUE);
		COMHelper::TestOk(hr);
		std::cout << "Creation du contact effectuee "
			"avec succes" << std::endl;
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
