﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Windows7.Multitouch;
using Windows7.Multitouch.WinForms;

namespace BasicGestureCSharp
{
    public partial class Form1 : Form
    {

        Brush brush = new SolidBrush(SystemColors.WindowText);
        private readonly Windows7.Multitouch.GestureHandler gestureHandler;
        private string msg;
        double Angle = 0.0;

        public Form1()
        {
            InitializeComponent();
            
            if (!Windows7.Multitouch.TouchHandler.DigitizerCapabilities.IsMultiTouchReady)
            {
                MessageBox.Show("Multitouch indisponible");
                Environment.Exit(1);
            }
            gestureHandler = Factory.CreateHandler<Windows7.Multitouch.GestureHandler>(this);

            gestureHandler.Pan += OnPan;
            gestureHandler.Rotate += OnRotate;
            gestureHandler.TwoFingerTap += OnTwoFingerTap;
            gestureHandler.Zoom += OnZoom;
            gestureHandler.PressAndTap += OnPressAndTap;
            
        }

        private void OnPan(object sender, GestureEventArgs args)
        {
            msg = String.Format("Pan : Location X: {0} Y: {1} Translation Width: {2}, Height{3}",
                args.Location.X,
                args.Location.Y,
                args.PanTranslation.Width,
                args.PanTranslation.Height);
            Invalidate();
        }

        private void OnRotate(object sender, GestureEventArgs args)
        {
            Angle += args.RotateAngle;
            msg = String.Format("Rotate : Centre X: {0} Y: {1} Angle: {2}",
                args.Center.X,
                args.Center.Y,
                Angle);
            Invalidate();
        }

        private void OnTwoFingerTap(object sender, GestureEventArgs args)
        {
            msg = String.Format("Two Finger Tap : Location X: {0} Y: {1}",
            args.Location.X,
            args.Location.Y);
            Invalidate();
        }

        private void OnZoom(object sender, GestureEventArgs args)
        {
            msg = String.Format("Zoom : Facteur {0}",
                args.ZoomFactor);
            Invalidate();
        }

        private void OnPressAndTap(object sender, GestureEventArgs args)
        {
            msg = String.Format("Press and Tap");
            Invalidate();
        }

        private void OnPaint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            g.DrawString(msg, Font, brush, 0, 0);
        }
    }
}
