﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Windows7.Multitouch;
using Windows7.Multitouch.WinForms;

namespace BasicTouchCSharp
{
    public partial class Form1 : Form
    {
        Brush brush = new SolidBrush(SystemColors.WindowText);
        private readonly Windows7.Multitouch.TouchHandler touchHandler;
        private string msg;

        public Form1()
        {
            InitializeComponent();
            if (!Windows7.Multitouch.TouchHandler.DigitizerCapabilities.IsMultiTouchReady)
            {
                MessageBox.Show("Multitouch indisponible");
                Environment.Exit(1);
            }
            touchHandler = Factory.CreateHandler<Windows7.Multitouch.TouchHandler>(this);

            touchHandler.TouchDown += OnTouchDown;
            touchHandler.TouchMove += OnTouchMove;
            touchHandler.TouchUp += OnTouchUp;

        }

        private void OnTouchDown(object sender, TouchEventArgs args)
        {
            msg = String.Format("TouchDown : Location X: {0} Y: {1} Id: {2}",
                 args.Location.X,
                 args.Location.Y,
                 args.Id);
            Invalidate();
        }
        private void OnTouchMove(object sender, TouchEventArgs args)
        {
            msg = String.Format("TouchMove : Location X: {0} Y: {1} Id: {2}",
                 args.Location.X,
                 args.Location.Y,
                 args.Id);
            Invalidate();
        }
        private void OnTouchUp(object sender, TouchEventArgs args)
        {
            msg = String.Format("TouchUp : Location X: {0} Y: {1} Id: {2}",
                 args.Location.X,
                 args.Location.Y,
                 args.Id);
            Invalidate();
        }

        private void OnPaint(object sender, PaintEventArgs e)
        {
            Graphics g = e.Graphics;
            g.DrawString(msg, Font, brush, 0, 0);
        }
    }
}
