﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using System.Diagnostics;

namespace DemoInertie
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private TextBlock textblock = new TextBlock();
        private string msg = "";
        private Brush brush = new SolidColorBrush(Colors.Black);

        public MainWindow()
        {
            InitializeComponent();
        }

        private void OnLoad(object sender, RoutedEventArgs e)
        {
            textblock.Text = msg;
            Canvas.SetTop(textblock, 0);
            Canvas.SetLeft(textblock, 0);
            MyCanvas.Children.Add(textblock);
        }

        private void OnManipulationStarting(object sender, ManipulationStartingEventArgs e)
        {
            Trace.WriteLine("Manipulation Starting");
            e.Mode = ManipulationModes.All;
            e.ManipulationContainer = MyCanvas;
            e.Handled = true;
        }

        private void OnManipulationInertiaStarting(object sender, ManipulationInertiaStartingEventArgs e)
        {
            Trace.WriteLine("Inertia Manipulation Starting");
             e.TranslationBehavior.DesiredDeceleration = 1.0 * 96.0 / (1000.0 * 1000.0);
             e.RotationBehavior.DesiredDeceleration = 120 / (1000.0 * 1000.0); 
             e.ExpansionBehavior.DesiredDeceleration =  1.0 * 96 / (1000.0 * 1000.0);
            //e.TranslationBehavior.DesiredDisplacement = 100.0;
            //e.RotationBehavior.DesiredDeceleration = 120.0;
            //e.ExpansionBehavior.DesiredDeceleration = 10.0;

            e.Handled = true;
        }


        private void OnManipulationDelta(object sender, ManipulationDeltaEventArgs e)
        {
            FrameworkElement fe = e.Source as FrameworkElement;
            if (fe == null || !fe.Name.Equals("logoProgrammez"))
                return;

            Vector scale = e.DeltaManipulation.Scale;
            Vector translation = e.DeltaManipulation.Translation;
            double rotation = e.DeltaManipulation.Rotation;

            msg = String.Format("Manipulation -- Scale: ({0},{1}) Translation: ({3},{3}) Rotation: {4}°",
                scale.X, scale.Y,
                translation.X, translation.Y,
                rotation);
            textblock.Text = msg;



            // Obtenir la matrice de transformation courante;
            MatrixTransform mt = fe.RenderTransform as MatrixTransform;
            Matrix matrice = mt.Matrix;
            Point centre_image = new Point(fe.ActualWidth / 2, fe.ActualHeight / 2);
            // Définir le nouveau centre de l'image
            // via la matrice de transformation
            centre_image = matrice.Transform(centre_image);


            if (e.IsInertial)
            {
                double centrex = centre_image.X + fe.ActualWidth / 2;

                if (centrex <= 0 || centrex >= MyCanvas.ActualWidth)
                {
                    e.ReportBoundaryFeedback(e.DeltaManipulation);
                    e.Complete();
                    e.Handled = true;
                    return;
                }
            }
           

            // Modifier la matrice en fonction de la translation
            matrice.Translate(translation.X, translation.Y);
            // Modifier la matrice en fonction de la rotation
            matrice.RotateAt(rotation, centre_image.X, centre_image.Y);
            // Modifier la matrice en fonction du Zoom
            matrice.ScaleAt(scale.X, scale.Y, centre_image.X, centre_image.Y);
            // Affecter la nouvelle matrice à l'élément manipuler
            ((MatrixTransform)fe.RenderTransform).Matrix = matrice;

            e.Handled = true;

        }
    }
}
