﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using System.Diagnostics;

namespace DemoTouch
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private TextBlock textblock = new TextBlock();
        private string msg = "";
        private Brush brush = new SolidColorBrush(Colors.Black);
        private Point point = new Point();
        private int currentId;

        public MainWindow()
        {
            InitializeComponent();
        }

        private void OnLoad(object sender, RoutedEventArgs e)
        {
            textblock.Text = msg;
            Canvas.SetTop(textblock, 0);
            Canvas.SetLeft(textblock, 0);
            MyCanvas.Children.Add(textblock);
        }

        private void OnTouchDown(object sender, TouchEventArgs e)
        {
            Trace.WriteLine("Touch Down");
            TouchPoint tp = e.TouchDevice.GetTouchPoint(MyCanvas);
            msg = String.Format("Touch Down Id {0}, X={1}, Y={2}",
                tp.TouchDevice.Id,
                tp.Bounds.X,
                tp.Bounds.Y);
            textblock.Text = msg;
            point.X = tp.Bounds.X;
            point.Y = tp.Bounds.Y;
            currentId = tp.TouchDevice.Id;
            e.Handled = true;
        }

        private void OnTouchMove(object sender, TouchEventArgs e)
        {
            Trace.WriteLine("Touch Move");
            
            if (e.TouchDevice.Id != currentId)
            {
                e.Handled = true;
                return;
            }

            Line line = new Line();
            line.X1 = point.X;
            line.Y1 = point.Y;

            TouchPoint tp = e.TouchDevice.GetTouchPoint(MyCanvas);
            line.X2 = tp.Bounds.X;
            line.Y2 = tp.Bounds.Y;

            line.Stroke = System.Windows.Media.Brushes.Black;
            MyCanvas.Children.Add(line);
            point.X = tp.Bounds.X;
            point.Y = tp.Bounds.Y;
            currentId = tp.TouchDevice.Id;


            msg = String.Format("Touch Move Id {0}, X={1}, Y={2}",
                tp.TouchDevice.Id,
                tp.Bounds.X,
                tp.Bounds.Y);
            textblock.Text = msg;

            e.Handled = true;
        }
    }
}
