#pragma once
#include "pch.h"
#include "Library1_h.h"

namespace ABI
{
	namespace Library1
	{
		template <class T>
		class Iterator : public RuntimeClass<Windows::Foundation::Collections::IIterator<T>>
		{
			InspectableClass(L"Library1.Iterator", BaseTrust)
		
		public:
			typedef typename std::shared_ptr<std::vector<T>> V;
			typedef typename std::vector<T>::iterator IT;

		public:
			Iterator() {}

			HRESULT Init(const V & item)
			{
				_v = item;
				_it = _v->begin();
				if (_it != _v->end())
				{
					_element = *_it;
					_bElement = TRUE;
				}
				else
					_bElement = FALSE;
				return S_OK;
			}

		public:
			virtual /* propget */ HRESULT STDMETHODCALLTYPE get_Current(_Out_ T *current)
			{
				if (_it != _v->end())
				{
					_bElement = TRUE;
					_element = *_it;
					*current = _element;
				}
				else
				{
					_bElement = FALSE;
				}
				return S_OK;
			}

			virtual /* propget */ HRESULT STDMETHODCALLTYPE get_HasCurrent(_Out_ boolean *hasCurrent)
			{
				if (_bElement)
					*hasCurrent = TRUE;
				else
					*hasCurrent = FALSE;
				return S_OK;
			}

			virtual HRESULT STDMETHODCALLTYPE MoveNext(_Out_ boolean *hasCurrent)
			{
				if (_it != _v->end())
				{
					++_it;
					if (_it == _v->end())
						*hasCurrent = FALSE;
					else
						*hasCurrent = TRUE;
				}
				else
				{
					*hasCurrent = FALSE;
				}
				return S_OK;
			}

		private:
			V _v;
			IT _it;
			T _element;
			boolean _bElement = FALSE;
		};

		template <typename T>
		class Vector : public RuntimeClass<Windows::Foundation::Collections::IVector<T>, 
											Windows::Foundation::Collections::IIterable<T>>
		{
			InspectableClass(L"Library1.Vector", BaseTrust)

		public:
			Vector() 
			{
				std::shared_ptr<std::vector<T>> ptr(new std::vector<T>());
				_v = ptr;
			}

		public:

			// read methods
			virtual HRESULT STDMETHODCALLTYPE GetAt(_In_opt_ unsigned index, _Out_ T *item)
			{
				*item = (*_v)[index];
				return S_OK;
			}

			virtual /* propget */ HRESULT STDMETHODCALLTYPE get_Size(_Out_ unsigned *size)
			{
				*size = _v->size();
				return S_OK;
			}

			virtual HRESULT STDMETHODCALLTYPE GetView(_Outptr_result_maybenull_ Windows::Foundation::Collections::IVectorView<T> **view)
			{
				return E_NOTIMPL;
			}

			virtual HRESULT STDMETHODCALLTYPE IndexOf(_In_opt_ T value, _Out_ unsigned *index, _Out_ boolean *found)
			{
				unsigned foundedIndex = 0;
				bool founded = false;
				for (std::vector<T>::const_iterator it = _v->cbegin() ; it != _v->end() ; ++it)
				{
					const T & v = *it;
					if (v == value)
					{
						founded = true;
						break;
					}
					foundedIndex++;
				}
				if (founded == true)
				{
					*found = TRUE;
					*index = foundedIndex;
				}
				else
				{
					*found = FALSE;
				}
				return S_OK;
			}

			// write methods
			virtual HRESULT STDMETHODCALLTYPE SetAt(_In_ unsigned index, _In_opt_ T item)
			{
				if (index < _v->size())
				{
					(*_v)[index] = item;
				}
				return S_OK;
			}

			virtual HRESULT STDMETHODCALLTYPE InsertAt(_In_ unsigned index, _In_opt_ T item)
			{
				_v->emplace(_v->begin() + index, item);
				return S_OK;
			}

			virtual HRESULT STDMETHODCALLTYPE RemoveAt(_In_ unsigned index)
			{
				if (index < _v->size())
				{
					_v->erase(_v->begin() + index);
				}
				return S_OK;
			}

			virtual HRESULT STDMETHODCALLTYPE Append(_In_opt_ T item)
			{
				_v->emplace_back(item);
				return S_OK;
			}

			virtual HRESULT STDMETHODCALLTYPE RemoveAtEnd()
			{
				if (!_v->empty())
				{
					_v->pop_back();
				}
				return S_OK;
			}

			virtual HRESULT STDMETHODCALLTYPE Clear()
			{
				_v->clear();
				return S_OK;
			}

			virtual HRESULT STDMETHODCALLTYPE First(_Outptr_result_maybenull_ Windows::Foundation::Collections::IIterator<T> **first)
			{
				ComPtr<Iterator<T>> p = Make<Iterator<T>>();
				p->Init(_v);
				*first = p.Detach();
				return S_OK;
			}

		private:
			//std::vector<T> _v;
			std::shared_ptr<std::vector<T>> _v;
		};
	}
}
