#include "pch.h"
#include "Root.h"
#include "Utility.h"
#include "Logger.h"
#include "Collection.h"

namespace ABI
{
	namespace Library1
	{
		STDMETHODIMP Root::GetLoggerAsync(Windows::Foundation::IAsyncOperation<ILogger*>** value)
		{
			ComPtr<task_based_async_operation<ILogger>> pObject = Make<task_based_async_operation<ILogger>>(
				std::async([&]() -> ILogger*
			{
				ComPtr<Logger> p = Make<Logger>();
				return p.Detach();
			}));
			*value = pObject.Detach();
			return S_OK;
		}

		STDMETHODIMP Root::GetVector(Windows::Foundation::Collections::IVector<HSTRING>** value)
		{
			ComPtr<Vector<HSTRING>> v = Make<Vector<HSTRING>>();
			HString str;
			str.Set(L"String1");
			v->Append(str.Detach());
			str.Set(L"String2");
			v->Append(str.Detach());
			str.Set(L"String3");
			v->Append(str.Detach());
			str.Set(L"String4");
			v->Append(str.Detach());
			*value = v.Detach();
			return S_OK;
		}

		STDMETHODIMP Root::GetVectorInt(Windows::Foundation::Collections::IVector<int>** value)
		{
			ComPtr<Vector<int>> v = Make<Vector<int>>();
			v->Append(10);
			v->Append(20);
			v->Append(30);
			v->Append(40);
			*value = v.Detach();
			return S_OK;
		}
	}
}