﻿using CocosSharp;
using System;
using System.Collections.Generic;
using System.Text;

namespace Xamarin.GameWatch.Fire
{
    public static class GameController
    {
        
        public static CCGameView GameView
        {
            get;
            private set;
        }

        public static void Initialize(CCGameView gameView)
        {
            //Initialisation de notre propriété statique
            GameView = gameView;

            //Initialisation des repository pour les ressources (où sont les ressources ?)
            var contentSearchPaths = new List<string>() { "Fonts", "Sounds", "Images" };            
            GameView.ContentManager.SearchPaths = contentSearchPaths;

            //Ici nous utiliserons une faible résolution pour donner une apparence 
            //pixel art 
            int width = 240;
            int height = 161;
            GameView.DesignResolution = new CCSizeI(width, height);

            //Notre première scène que nous allons exécuter :-)
            var scene = new MainScene(GameView);            
            GameView.RunWithScene(scene);
        }

    }
}
